#include <thread>

#include "globals.h"
#include "utils/sharedMemoryLocks.h"

bool verbose = false;

int num_threads = 0;
uint64_t counter = 0;
uint64_t val = 0;

TASLock tas_lock;
TTASLock ttas_lock;

void increment_tas() {
  for(int i = 0; i < val; i++) {
    tas_lock.lock();
    int new_counter = counter;
    new_counter++;
    counter = new_counter;
    tas_lock.unlock();
  }
}

void increment_ttas() {
  for(int i = 0; i < val; i++) {
    ttas_lock.lock();
    int new_counter = counter;
    new_counter++;
    counter = new_counter;
    ttas_lock.unlock();
  }
}

int main(int argc, char** argv) {
  assert(argc == 3);
  num_threads = atoi(argv[1]);
  val = atoi(argv[2]);
  std::thread* t = new std::thread[num_threads];

  for(int i = 0; i < num_threads; ++i) {
    t[i] = std::thread(increment_tas);
  }

  for(int i = 0; i < num_threads; ++i) {
    t[i].join();
  }

  //  cout << "counter: " << counter << ", num_threads: " << num_threads << ", val: " << val << endl;
  assert(counter == num_threads * val);
  counter = 0;

  for(int i = 0; i < num_threads; ++i) {
    t[i] = std::thread(increment_ttas);
  }

  for(int i = 0; i < num_threads; ++i) {
    t[i].join();
  }

  printf("OK\n");

  delete [] t;

  return 0;
}
