#include "globals.h"
#include "utils/stats.h"

bool verbose = false;

int main() {
  MemoryStats s;

  s.zero_all_stats();

  s.increase_mem_stats(11, 21);
  s.increase_atomic_stats(3, 111, 189);
  s.increase_all_stats(67, 67, 67, 67, 67);

  assert(s.mem_reads_ == 78);
  assert(s.mem_writes_ == 88);
  assert(s.cas_succ_ == 70);
  assert(s.cas_unsucc_ == 178);
  assert(s.fad_ == 256);

  s.calculate_total_stats();

  assert(s.mem_reads_ == 78);
  assert(s.mem_writes_ == 88);
  assert(s.cas_succ_ == 70);
  assert(s.cas_unsucc_ == 178);
  assert(s.fad_ == 256);

  assert(s.mem_total_ == 166);
  assert(s.cas_total_ == 248);
  assert(s.fad_total_ == 256);
  assert(s.atomic_total_ == 504);

  s.zero_partial_stats();

  assert(s.mem_reads_ == 0);
  assert(s.mem_writes_ == 0);
  assert(s.cas_succ_ == 0);
  assert(s.cas_unsucc_ == 0);
  assert(s.fad_ == 0);

  assert(s.mem_total_ != 0);
  assert(s.cas_total_ != 0);
  assert(s.fad_total_ != 0);
  assert(s.atomic_total_ != 0);

  s.zero_all_stats();

  assert(s.mem_reads_ == 0);
  assert(s.mem_writes_ == 0);
  assert(s.cas_succ_ == 0);
  assert(s.cas_unsucc_ == 0);
  assert(s.fad_ == 0);

  assert(s.mem_total_ == 0);
  assert(s.cas_total_ == 0);
  assert(s.fad_total_ == 0);
  assert(s.atomic_total_ == 0);

  printf("OK\n");

  return 0;
}
