#include "globals.h"

#include "utils/graphIO.h"
#include "utils/debug.h"
#include "representations/diffAnalysis.h"

#include "representations/tradListGraphR.h"
#include "representations/metisR.h"
#include "representations/diffGraphR.h"

#include "partitioners/recPart.h"

#include "coders/myVarintByteBasedCoder.h"
#include "coders/myVarintByteBasedRecCoder.h"
#include "coders/myVarintByteBasedRecOpt1Coder.h"
#include "coders/myVarintByteBasedNoDiffCoder.h"
#include "coders/myVarintWordBasedCoder.h"
#include "coders/myVarintWordBasedRecCoder.h"
#include "coders/myVarintWordBasedNoDiffCoder.h"
#include "coders/myVarintByteBasedHybridCoder.h"

#include "offsetStructures/offsetsPtrs.h"
#include "offsetStructures/offsetsBV.h"
#include "offsetStructures/offsetsBV_IL.h"
#include "offsetStructures/offsetsBV_SD.h"
#include "offsetStructures/offsetsBV_RRR.h"

TradListGraphR* rep_original_t = NULL;
TradListGraphR* rep_original_blelloch_inorder_t = NULL;
TradListGraphR* rep_original_degree_t = NULL;
TradListGraphR* rep_bisected_t = NULL;

MetisR* rep_original_m = NULL;

SimpleRecGraphR* rep_bisected_r = NULL;

int main() {
  int balance = 1;
  int full = 1;
  int lvls = 0;
  const char* file_name = "../input/g1.txt";

  GraphIO::loadGraph(file_name, &rep_original_t, &rep_original_m, 1);

  RecPart part;
  CutResults* res;

  DEBUG_FUNCTION("> Partitioning...", part.recEdgePartition(METIS_PARTITIONING, rep_original_m, balance, full, lvls, &rep_bisected_r, &res), "Done");
  DEBUG_FUNCTION("  > Verifying bisected representation...", verifySimpleRecGraphR(rep_bisected_r), "Done");
  DEBUG_FUNCTION("> Loading (converting) recursive computed representation back to contiguous trad adj.", rep_bisected_t = convertSimpleRecToContiguousTradList(rep_bisected_r, rep_original_t), "Done");
  DEBUG_FUNCTION("  > Verifying...", verifyContiguousTradListGraphR(rep_bisected_t), "Done");

/*
    for(const auto& item: *(rep_original_t->adj_)) {
      v_id v = item.first;
      cout << v << " : ";
      for(const auto& n: item.second) {
      cout << n << " ";
      }
      cout << endl;
      }

      cout << "---------------------" << endl;

      for(const auto& item: *(rep_bisected_t->adj_)) {
      v_id v = item.first;
      cout << v << " : ";
      for(const auto& n: item.second) {
      cout << n << " ";
      }
      cout << endl;
      }*/

  DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>* dif_B;
  DiffGraphR<OffsetsPtrs, MyVarintByteBasedRecCoder>* dif_B_rec;
  DiffGraphR<OffsetsPtrs, MyVarintByteBasedHybridCoder>* dif_B_hybrid;
  DiffGraphR<OffsetsPtrs, MyVarintByteBasedRecOpt1Coder>* dif_B_rec_opt1;
  DiffGraphR<OffsetsPtrs, MyVarintByteBasedNoDiffCoder>* dif_B_nodif;

  DiffGraphR<OffsetsPtrs, MyVarintWordBasedCoder>* dif_W;
  DiffGraphR<OffsetsPtrs, MyVarintWordBasedRecCoder>* dif_W_rec;
  DiffGraphR<OffsetsPtrs, MyVarintWordBasedNoDiffCoder>* dif_W_nodif;

  DiffGraphR<OffsetsBV, MyVarintByteBasedCoder>* dif_B_bv;
  DiffGraphR<OffsetsBV, MyVarintWordBasedCoder>* dif_W_bv;
  DiffGraphR<OffsetsBV_SD, MyVarintByteBasedCoder>* dif_B_bv_sd;
  DiffGraphR<OffsetsBV_SD, MyVarintWordBasedCoder>* dif_W_bv_sd;

  bool hack = true;

  cout << "Constructing dif_B" << endl;
  dif_B = new DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>(NO_CHANGES, rep_bisected_r, rep_original_t);
  cout << "Done" << endl;
  cout << "Adj data total size: " << dif_B->adj_data_total_size_in_bytes() << endl;
  //cout << "Off data total size: " << dif_B->offsets_total_size_in_bytes() << endl;

  cout << "Constructing dif_B_rec" << endl;
  dif_B_rec = new DiffGraphR<OffsetsPtrs, MyVarintByteBasedRecCoder>(NO_CHANGES, rep_bisected_r, rep_original_t, hack);
  cout << "Done" << endl;
  cout << "Adj data total size: " << dif_B_rec->adj_data_total_size_in_bytes() << endl;
  //cout << "Off data total size: " << dif_B_rec->offsets_total_size_in_bytes() << endl;

  cout << "Constructing dif_B_hybrid" << endl;
  dif_B_hybrid = new DiffGraphR<OffsetsPtrs, MyVarintByteBasedHybridCoder>(NO_CHANGES, rep_bisected_r, rep_original_t, hack);
  cout << "Done" << endl;
  cout << "Adj data total size: " << dif_B_hybrid->adj_data_total_size_in_bytes() << endl;
  //cout << "Off data total size: " << dif_B_hybrid->offsets_total_size_in_bytes() << endl;

  cout << "Constructing dif_B_rec_opt1" << endl;
  dif_B_rec_opt1 = new DiffGraphR<OffsetsPtrs, MyVarintByteBasedRecOpt1Coder>(NO_CHANGES, rep_bisected_r, rep_original_t, hack);
  cout << "Done" << endl;
  cout << "Adj data total size: " << dif_B_rec_opt1->adj_data_total_size_in_bytes() << endl;
  //cout << "Off data total size: " << dif_B_rec_opt1->offsets_total_size_in_bytes() << endl;

  cout << "Constructing dif_B_nodif" << endl;
  dif_B_nodif = new DiffGraphR<OffsetsPtrs, MyVarintByteBasedNoDiffCoder>(NO_CHANGES, rep_bisected_r, rep_original_t);
  cout << "Done" << endl;
  cout << "Adj data total size: " << dif_B_nodif->adj_data_total_size_in_bytes() << endl;
  //cout << "Off data total size: " << dif_B_nodif->offsets_total_size_in_bytes() << endl;

  cout << "Constructing dif_W" << endl;
  dif_W = new DiffGraphR<OffsetsPtrs, MyVarintWordBasedCoder>(NO_CHANGES, rep_bisected_r, rep_original_t);
  cout << "Done" << endl;
  cout << "Adj data total size: " << dif_W->adj_data_total_size_in_bytes() << endl;
  //cout << "Off data total size: " << dif_W->offsets_total_size_in_bytes() << endl;
  
  cout << "Constructing dif_W_rec" << endl;
  dif_W_rec = new DiffGraphR<OffsetsPtrs, MyVarintWordBasedRecCoder>(NO_CHANGES, rep_bisected_r, rep_original_t, hack);
  cout << "Done" << endl;
  cout << "Adj data total size: " << dif_W_rec->adj_data_total_size_in_bytes() << endl;
  //cout << "Off data total size: " << dif_W_rec->offsets_total_size_in_bytes() << endl;
  
  cout << "Constructing dif_W_nodif" << endl;
  dif_W_nodif = new DiffGraphR<OffsetsPtrs, MyVarintWordBasedNoDiffCoder>(NO_CHANGES, rep_bisected_r, rep_original_t);
  cout << "Done" << endl;
  cout << "Adj data total size: " << dif_W_nodif->adj_data_total_size_in_bytes() << endl;
  //cout << "Off data total size: " << dif_W_nodif->offsets_total_size_in_bytes() << endl;


  cout << "Constructing dif_B_bv" << endl;
  dif_B_bv = new DiffGraphR<OffsetsBV, MyVarintByteBasedCoder>(NO_CHANGES, rep_bisected_r, rep_original_t);
  cout << "Done" << endl;
  cout << "Adj data total size: " << dif_B_bv->adj_data_total_size_in_bytes() << endl;
  //cout << "Off data total size: " << dif_B_bv->offsets_total_size_in_bytes() << endl;

  cout << "Constructing dif_W_bv" << endl;
  dif_W_bv = new DiffGraphR<OffsetsBV, MyVarintWordBasedCoder>(NO_CHANGES, rep_bisected_r, rep_original_t);
  cout << "Done" << endl;
  cout << "Adj data total size: " << dif_W_bv->adj_data_total_size_in_bytes() << endl;
  //cout << "Off data total size: " << dif_W_bv->offsets_total_size_in_bytes() << endl;
  
  cout << "Constructing dif_B_bv_sd" << endl;
  dif_B_bv_sd = new DiffGraphR<OffsetsBV_SD, MyVarintByteBasedCoder>(NO_CHANGES, rep_bisected_r, rep_original_t);
  cout << "Done" << endl;
  cout << "Adj data total size: " << dif_B_bv_sd->adj_data_total_size_in_bytes() << endl;
  //cout << "Off data total size: " << dif_B_bv_sd->offsets_total_size_in_bytes() << endl;

  cout << "Constructing dif_W_bv_sd" << endl;
  dif_W_bv_sd = new DiffGraphR<OffsetsBV_SD, MyVarintWordBasedCoder>(NO_CHANGES, rep_bisected_r, rep_original_t);
  cout << "Done" << endl;
  cout << "Adj data total size: " << dif_W_bv_sd->adj_data_total_size_in_bytes() << endl;
  //cout << "Off data total size: " << dif_W_bv_sd->offsets_total_size_in_bytes() << endl;
 

  /* 
     cout << ">>> Loading (permuting-INORDER) from original representation." << endl;
     rep_original_blelloch_inorder_t = p->permute(rep_bisected_r, rep_original_t, INORDER);
     cout << "  > Verifying..." << endl;
     verifyTradListGraphR(rep_original_blelloch_inorder_t);

     cout << ">>> Loading (permuting-DEGREE) from original representation." << endl;
     rep_original_degree_t = p->permute(rep_bisected_r, rep_original_t, DEGREE_HIGH_TO_LOW);
     cout << "  > Verifying..." << endl;
     verifyTradListGraphR(rep_original_degree_t);

     cout << "Loading (converting) an adjacency list from recursive TradList representation to an original form..." << endl;
     rep_bisected_t = convertTradListToSimpleRec(rep_bisected_r, rep_original_t);
     cout << "  > Verifying..." << endl;
     verifyTradListGraphR(rep_bisected_t);
   */

  /*  assert(dif->adjUseV1Neighbors(0,2) == dif_rec->adjUseV1Neighbors(0,2));
      assert(dif->adjUseV1Neighbors(0,3) == dif->adjUseV1Neighbors(0,3));
      assert(dif->adjUseV1Neighbors(2,0) == );
      assert(dif->adjUseV1Neighbors(2,1) == );
      assert(dif->adjUseV1Neighbors(2,2) == );
      assert(dif->adjUseV1Neighbors(2,3) == );
      assert(dif->adjUseV1Neighbors(2,4) == );

      assert(dif->adjUseV2Neighbors(0,2) == );
      assert(dif->adjUseV2Neighbors(0,3) == );
      assert(dif->adjUseV2Neighbors(2,0) == );
      assert(dif->adjUseV2Neighbors(2,1) == );
      assert(dif->adjUseV2Neighbors(2,2) == );
      assert(dif->adjUseV2Neighbors(2,3) == );
      assert(dif->adjUseV2Neighbors(2,4) == );

      assert(dif->adjUseMinNeighbors(0,2) == );
      assert(dif->adjUseMinNeighbors(0,3) == );
      assert(dif->adjUseMinNeighbors(2,0) == );
      assert(dif->adjUseMinNeighbors(2,1) == );
      assert(dif->adjUseMinNeighbors(2,2) == );
      assert(dif->adjUseMinNeighbors(2,3) == );
      assert(dif->adjUseMinNeighbors(2,4) == );

   */

  for(int x = 0; x < rep_original_t->n_; ++x) {
    v_id deg_B = 0;
    v_id deg_B_rec = 0;
    v_id deg_B_hybrid = 0;
    v_id deg_B_rec_opt1 = 0;
    v_id deg_B_nodif = 0;

    v_id deg_W = 0;
    v_id deg_W_rec = 0;
    v_id deg_W_nodif = 0;

    v_id deg_B_bv = 0;
    v_id deg_W_bv = 0;
    v_id deg_B_bv_sd = 0;
    v_id deg_W_bv_sd = 0;

    /////////////

    v_id* neighs_B = dif_B->getVertexNeighborsAndDegree(x, &deg_B);
    string* neighs_B_rec = dif_B_rec->getVertexNeighborsStrAndDegree(x, &deg_B_rec);
    string* neighs_B_hybrid = dif_B_hybrid->getVertexNeighborsStrAndDegree(x, &deg_B_hybrid);
    string* neighs_B_rec_opt1 = dif_B_rec_opt1->getVertexNeighborsStrAndDegree(x, &deg_B_rec_opt1);
    v_id* neighs_B_nodif = dif_B_nodif->getVertexNeighborsAndDegree(x, &deg_B_nodif);
   
    v_id* neighs_W = dif_W->getVertexNeighborsAndDegree(x, &deg_W);
    string* neighs_W_rec = dif_W_rec->getVertexNeighborsStrAndDegree(x, &deg_W_rec);
    v_id* neighs_W_nodif = dif_W_nodif->getVertexNeighborsAndDegree(x, &deg_W_nodif);

    v_id* neighs_B_bv = dif_B_bv->getVertexNeighborsAndDegree(x, &deg_B_bv);
    v_id* neighs_W_bv = dif_W_bv->getVertexNeighborsAndDegree(x, &deg_W_bv);
    v_id* neighs_B_bv_sd = dif_B_bv_sd->getVertexNeighborsAndDegree(x, &deg_B_bv_sd);
    v_id* neighs_W_bv_sd = dif_W_bv_sd->getVertexNeighborsAndDegree(x, &deg_W_bv_sd);

    /////////////

    assert(deg_B == deg_B_rec);
    assert(deg_B_rec == deg_B_rec_opt1);
    assert(deg_B_rec_opt1 == deg_B_nodif);
    assert(deg_B_nodif == deg_W);
    assert(deg_W_rec == deg_W_nodif);
    assert(deg_W_rec == deg_B_hybrid);

    assert(deg_W_nodif == deg_B_bv);
    assert(deg_B_bv == deg_W_bv);
    assert(deg_W_bv == deg_B_bv_sd);
    assert(deg_B_bv_sd == deg_W_bv_sd);

    /////////////

    vector<v_id> neighbors_v_id_B;
    vector<v_id> neighbors_v_id_B_nodif;
    vector<v_id> neighbors_v_id_W;
    vector<v_id> neighbors_v_id_W_nodif;

    vector<v_id> neighbors_v_id_B_bv;
    vector<v_id> neighbors_v_id_B_bv_sd;
    vector<v_id> neighbors_v_id_W_bv;
    vector<v_id> neighbors_v_id_W_bv_sd;

    ////////////

    for(int i = 0; i < deg_B; ++i) {
      neighbors_v_id_B.push_back( neighs_B[i] );
      neighbors_v_id_B_nodif.push_back( neighs_B_nodif[i] );
      neighbors_v_id_W.push_back( neighs_W[i] );
      neighbors_v_id_W_nodif.push_back( neighs_W_nodif[i] );

      neighbors_v_id_B_bv.push_back( neighs_B_bv[i] );
      neighbors_v_id_W_bv.push_back( neighs_W_bv[i] );
      neighbors_v_id_B_bv_sd.push_back( neighs_B_bv_sd[i] );
      neighbors_v_id_W_bv_sd.push_back( neighs_W_bv_sd[i] );
    }

    sort(neighbors_v_id_B.begin(), neighbors_v_id_B.end());
    sort(neighbors_v_id_B_nodif.begin(), neighbors_v_id_B_nodif.end());
    sort(neighbors_v_id_W.begin(), neighbors_v_id_W.end());
    sort(neighbors_v_id_W_nodif.begin(), neighbors_v_id_W_nodif.end());

    sort(neighbors_v_id_B_bv.begin(), neighbors_v_id_B_bv.end());
    sort(neighbors_v_id_W_bv.begin(), neighbors_v_id_W_bv.end());
    sort(neighbors_v_id_B_bv_sd.begin(), neighbors_v_id_B_bv_sd.end());
    sort(neighbors_v_id_W_bv_sd.begin(), neighbors_v_id_W_bv_sd.end());

    for(int i = 0; i < deg_B; ++i) {
      assert(neighbors_v_id_B[i] == neighbors_v_id_B_nodif[i]);
      assert(neighbors_v_id_B_nodif[i] == neighbors_v_id_W[i]);
      assert(neighbors_v_id_W[i] == neighbors_v_id_W_nodif[i]);

      assert(neighbors_v_id_W_nodif[i] == neighbors_v_id_B_bv[i]);
      assert(neighbors_v_id_B_bv[i] == neighbors_v_id_W_bv[i]);
      assert(neighbors_v_id_W_bv[i] == neighbors_v_id_W_bv_sd[i]);
    }

    vector<string> original_neighbors_str;
    vector<string> decoded_neighbors_str_B;
    vector<string> decoded_neighbors_str_B_hybrid;
    vector<string> decoded_neighbors_str_B_opt1;
    vector<string> decoded_neighbors_str_W;

    for(int i = 0; i < deg_B; ++i) {
      original_neighbors_str.push_back( *((*rep_bisected_r)[neighs_B[i]]) );
      decoded_neighbors_str_B.push_back( neighs_B_rec[i] );
      decoded_neighbors_str_B_hybrid.push_back( neighs_B_hybrid[i] );
      decoded_neighbors_str_B_opt1.push_back( neighs_B_rec_opt1[i] );
      decoded_neighbors_str_W.push_back( neighs_W_rec[i] );
    }

    sort(original_neighbors_str.begin(), original_neighbors_str.end());
    sort(decoded_neighbors_str_B.begin(), decoded_neighbors_str_B.end());
    sort(decoded_neighbors_str_B_opt1.begin(), decoded_neighbors_str_B_opt1.end());
    sort(decoded_neighbors_str_B_hybrid.begin(), decoded_neighbors_str_B_hybrid.end());
    sort(decoded_neighbors_str_W.begin(), decoded_neighbors_str_W.end());

    for(int i = 0; i < deg_B; ++i) {
      assert(original_neighbors_str[i] == decoded_neighbors_str_B[i]);
      assert(decoded_neighbors_str_B[i] == decoded_neighbors_str_B_opt1[i]);
      assert(decoded_neighbors_str_B[i] == decoded_neighbors_str_B_hybrid[i]);
      assert(decoded_neighbors_str_B_opt1[i] == decoded_neighbors_str_W[i]);
    }

    switch(x) {
      case 0:
        assert(deg_B == 1);
        break;
      case 1:
        assert(deg_B == 2);
        break;
      case 2:
        assert(deg_B == 4);
        break;
      case 3:
        assert(deg_B == 3);
        break;
      case 4:
        assert(deg_B == 4);
        break;
      case 5:
        assert(deg_B == 4);
        break;
      case 6:
        assert(deg_B == 3);
        break;
      case 7:
        assert(deg_B == 4);
        break;
      case 8:
        assert(deg_B == 3);
        break;
    }

    delete [] neighs_B;
    delete [] neighs_B_rec;
    delete [] neighs_B_hybrid;
    delete [] neighs_B_rec_opt1;
    delete [] neighs_B_nodif;
    delete [] neighs_W;
    delete [] neighs_W_rec;
    delete [] neighs_W_nodif;

    delete [] neighs_B_bv;
    delete [] neighs_W_bv;
    delete [] neighs_B_bv_sd;
    delete [] neighs_W_bv_sd;
  }

  /*
     assert(neighs[0] == 0);
     assert(neighs[1] == 1);
     assert(neighs[2] == 3);
     assert(neighs[3] == 4);
     assert(dif->getVertexDegree(2) == 4);
     delete [] neighs;

     neighs_nr = 0;
     neighs = dif->getVertexNeighborsAndDegree(6, &neighs_nr);
     assert(neighs_nr == 3);
     assert(neighs[0] == 5);
     assert(neighs[1] == 7);
     assert(neighs[2] == 8);
     assert(dif->getVertexDegree(6) == 3);
     delete [] neighs;

     neighs_nr = 0;
     neighs = dif->getVertexNeighborsAndDegree(7, &neighs_nr);
     assert(neighs_nr == 4);
     assert(neighs[0] == 4);
     assert(neighs[1] == 5);
     assert(neighs[2] == 6);
     assert(neighs[3] == 8);
     assert(dif->getVertexDegree(7) == 4);
     delete [] neighs;

     neighs_nr = 0;
     neighs = dif->getVertexNeighborsAndDegree(8, &neighs_nr);
     assert(neighs_nr == 3);
     assert(neighs[0] == 5);
     assert(neighs[1] == 6);
     assert(neighs[2] == 7);
     assert(dif->getVertexDegree(8) == 3);
     delete [] neighs;

     neighs_nr = 0;
     neighs = dif->getVertexNeighborsAndDegree(0, &neighs_nr);
     assert(neighs_nr == 1);
     assert(neighs[0] == 2);
     assert(dif->getVertexDegree(0) == 1);
     delete [] neighs;
   */



  /*  assert(dif->adjUseV1Neighbors(0,2) == true);
      assert(dif->adjUseV1Neighbors(0,3) == false);
      assert(dif->adjUseV1Neighbors(2,0) == true);
      assert(dif->adjUseV1Neighbors(2,1) == true);
      assert(dif->adjUseV1Neighbors(2,2) == false);
      assert(dif->adjUseV1Neighbors(2,3) == true);
      assert(dif->adjUseV1Neighbors(2,4) == true);

      assert(dif->adjUseV2Neighbors(0,2) == true);
      assert(dif->adjUseV2Neighbors(0,3) == false);
      assert(dif->adjUseV2Neighbors(2,0) == true);
      assert(dif->adjUseV2Neighbors(2,1) == true);
      assert(dif->adjUseV2Neighbors(2,2) == false);
      assert(dif->adjUseV2Neighbors(2,3) == true);
      assert(dif->adjUseV2Neighbors(2,4) == true);

      assert(dif->adjUseMinNeighbors(0,2) == true);
      assert(dif->adjUseMinNeighbors(0,3) == false);
      assert(dif->adjUseMinNeighbors(2,0) == true);
      assert(dif->adjUseMinNeighbors(2,1) == true);
      assert(dif->adjUseMinNeighbors(2,2) == false);
      assert(dif->adjUseMinNeighbors(2,3) == true);
      assert(dif->adjUseMinNeighbors(2,4) == true);

      v_id neighs_nr = 0;
      v_id* neighs = dif->getVertexNeighborsAndDegree(2, &neighs_nr);
      assert(neighs_nr == 4);
      assert(neighs[0] == 0);
      assert(neighs[1] == 1);
      assert(neighs[2] == 3);
      assert(neighs[3] == 4);
      assert(dif->getVertexDegree(2) == 4);
      delete [] neighs;

      neighs_nr = 0;
      neighs = dif->getVertexNeighborsAndDegree(6, &neighs_nr);
      assert(neighs_nr == 3);
      assert(neighs[0] == 5);
      assert(neighs[1] == 7);
      assert(neighs[2] == 8);
      assert(dif->getVertexDegree(6) == 3);
      delete [] neighs;

      neighs_nr = 0;
      neighs = dif->getVertexNeighborsAndDegree(7, &neighs_nr);
      assert(neighs_nr == 4);
      assert(neighs[0] == 4);
      assert(neighs[1] == 5);
      assert(neighs[2] == 6);
      assert(neighs[3] == 8);
      assert(dif->getVertexDegree(7) == 4);
      delete [] neighs;

      neighs_nr = 0;
      neighs = dif->getVertexNeighborsAndDegree(8, &neighs_nr);
      assert(neighs_nr == 3);
      assert(neighs[0] == 5);
      assert(neighs[1] == 6);
      assert(neighs[2] == 7);
      assert(dif->getVertexDegree(8) == 3);
      delete [] neighs;

      neighs_nr = 0;
      neighs = dif->getVertexNeighborsAndDegree(0, &neighs_nr);
      assert(neighs_nr == 1);
      assert(neighs[0] == 2);
      assert(dif->getVertexDegree(0) == 1);
      delete [] neighs;
   */

  for(auto& item: *rep_bisected_r) {
    string* result = item.second;
    delete result;
  }

  for(auto& item: *res) {
    delete item.second;
  }

  delete rep_original_t;
  delete res;

  delete rep_original_m;

  delete dif_B;
  delete dif_B_rec;
  delete dif_B_hybrid;
  delete dif_B_rec_opt1;
  delete dif_B_nodif;
  delete dif_W;
  delete dif_W_rec;
  delete dif_W_nodif;

  delete dif_B_bv;
  delete dif_W_bv;
  delete dif_B_bv_sd;
  delete dif_W_bv_sd;

  printf("OK\n");

  return 0;
}
