#include "globals.h"

#include "utils/graphIO.h"
#include "utils/debug.h"
#include "representations/diffAnalysis.h"

#include "representations/tradListGraphR.h"
#include "representations/metisR.h"
#include "representations/diffGraphR.h"

#include "coders/myVarintByteBasedCoder.h"

#include "offsetStructures/offsetsPtrs.h"
#include "offsetStructures/offsetsPtrsCompressed.h"
#include "offsetStructures/offsetsBV.h"
#include "offsetStructures/offsetsBVCompressed.h"

TradListGraphR* rep_original_t = NULL;
MetisR* rep_original_m = NULL;
SimpleRecGraphR* rep_bisected_r = NULL;

int main() {
  const char* file_name = "../input/g1.txt";
  std::string GRAPH_FILE_R = "../input/g1.txt_bisected";

  GraphIO::loadGraph(file_name, &rep_original_t, &rep_original_m, 1);
  rep_bisected_r = GraphIO::readRecursivePartitioningFromFile(GRAPH_FILE_R);

  DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>* dif_B;
  DiffGraphR<OffsetsPtrsCompressed, MyVarintByteBasedCoder>* dif_B_com;
  DiffGraphR<OffsetsBV, MyVarintByteBasedCoder>* dif_B_bv;
  DiffGraphR<OffsetsBVCompressed, MyVarintByteBasedCoder>* dif_B_bv_com;

  cout << "Constructing dif_B" << endl;
  dif_B = new DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>(NO_CHANGES, rep_bisected_r, rep_original_t);
  cout << "Done" << endl;

  cout << "Constructing dif_B_com" << endl;
  dif_B_com = new DiffGraphR<OffsetsPtrsCompressed, MyVarintByteBasedCoder>(NO_CHANGES, rep_bisected_r, rep_original_t);
  cout << "Done" << endl;

  cout << "Constructing dif_B_bv" << endl;
  dif_B_bv = new DiffGraphR<OffsetsBV, MyVarintByteBasedCoder>(NO_CHANGES, rep_bisected_r, rep_original_t);
  cout << "Done" << endl;

  cout << "Constructing dif_B_bv_com" << endl;
  dif_B_bv_com = new DiffGraphR<OffsetsBVCompressed, MyVarintByteBasedCoder>(NO_CHANGES, rep_bisected_r, rep_original_t);
  cout << "Done" << endl;

  for(int x = 0; x < rep_original_t->n_; ++x) {
    assert(dif_B->offsets_->getVertexOffset(x) == dif_B_bv->offsets_->getVertexOffset(x));
    assert(dif_B->offsets_->getVertexOffset(x) == dif_B_com->offsets_->getVertexOffset(x));
    assert(dif_B->offsets_->getVertexOffset(x) == dif_B_bv_com->offsets_->getVertexOffset(x));
  }

  for(auto& item: *rep_bisected_r) {
    string* result = item.second;
    delete result;
  }

  delete rep_original_t;
  delete rep_original_m;

  delete dif_B;
  delete dif_B_com;
  delete dif_B_bv;
  delete dif_B_bv_com;

  printf("OK\n");

  return 0;
}
