#include "globals.h"
#include "utils/graphIO.h"
#include "utils/debug.h"
#include "representations/tradListGraphR.h"
#include "representations/metisR.h"
#include "partitioners/recPart.h"

bool verbose = true;
const int v_nr = 10;
const int e_nr = 21;

int main(int argc, char** argv) {
  const char* file_name = "../input/g2.txt";
  TradListGraphR*  loaded_g_t = NULL;
  MetisR* loaded_g_m = NULL;

  assert(argc == 5);
  int balance = atoi(argv[1]);
  int full = atoi(argv[2]);
  int lvls = atoi(argv[3]);

  GraphIO::loadGraph(file_name, &loaded_g_t, &loaded_g_m);

  RecPart part;
  SimpleRecGraphR* r;
  CutResults* res;
  part.recEdgePartition(METIS_PARTITIONING, loaded_g_m, balance, full, lvls, &r, &res);

  unsigned int first_len = (*r)[0]->length();

  for(auto& item: *r) {
    idx_t v = item.first;
    string* result = item.second;
    assert(first_len == result->length());
    if(v <= 4) {
      assert((*result)[0] == '0');
    }
    else {
      assert((*result)[0] == '1');
    }
    delete result;
  }

  for(auto& item: *res) {
    delete item.second;
  }

  delete r;
  delete res;

  delete loaded_g_t;
  delete loaded_g_m;

  printf("OK\n");

  return 0;
}
