#include "globals.h"
#include "utils/graphIO.h"
#include "utils/debug.h"
#include "representations/tradListGraphR.h"
#include "representations/metisR.h"
#include "partitioners/recPart.h"

bool verbose = true;
const int v_nr = 10;
const int e_nr = 21;

int main() {
  const char* file_name = "../input/g2.txt";
  TradListGraphR*  loaded_g_t = NULL;
  MetisR* loaded_g_m = NULL;

  int balance = 1;
  int full = 1;
  int lvls = 0;

  GraphIO::loadGraph(file_name, &loaded_g_t, &loaded_g_m);

  RecPart part;
  SimpleRecGraphR* r;
  CutResults* res;
  part.recEdgePartition(METIS_PARTITIONING_MULTITHREADED, loaded_g_m, balance, full, lvls, &r, &res);

  RecPart _part;
  SimpleRecGraphR* _r;
  CutResults* _res;
  _part.recEdgePartition(METIS_PARTITIONING, loaded_g_m, balance, full, lvls, &_r, &_res);


  /*
  // Compare two variants if identical
  for(int i = 0; i < v_nr; ++i) {
    string* r_val = (*r)[i];
    string* _r_val = (*_r)[i];


    //assert(r_val->compare(*_r_val) == 0);
  }

  cout << "no T: " << endl;
  for(int i = 0; i < v_nr; ++i) {
    string* r_val = (*_r)[i];
    cout << i << " " << *r_val << endl;

    //assert(r_val->compare(*_r_val) == 0);
  }



  cout << "T: " << endl;
  for(int i = 0; i < v_nr; ++i) {
    string* r_val = (*r)[i];
    cout << i << " " << *r_val << endl;

    //assert(r_val->compare(*_r_val) == 0);
  }*/

  for(int i = 0; i < v_nr; ++i) {
    string* r_val = (*r)[i];
    string* _r_val = (*_r)[i];
    assert(r_val->compare(*_r_val) == 0);
  }

  unsigned int first_len = (*r)[0]->length();
  assert(first_len == 4);

  int v_id = 0;
  for(auto& item: *r) {
    idx_t v = item.first;
    assert(v == v_id++);
  }

  int nr_1_0 = 0;
  int nr_1_1 = 0;
  int nr_1_2 = 0;
  int nr_1_3 = 0;

  for(auto& item: *r) {
    idx_t v = item.first;
    string* result = item.second;

    // (1): test for length equality
    assert(first_len == result->length());

    // (2): test for the sign of the first bit
    if(v <= 4) {
      assert((*result)[0] == '0');
    }
    else {
      assert((*result)[0] == '1');
    }

    // (3): get the number of 1s at various levels
    int val_0 = (*result)[0] - '0';
    int val_1 = (*result)[1] - '0';
    int val_2 = (*result)[2] - '0';
    int val_3 = (*result)[3] - '0';

    nr_1_0 += val_0;
    nr_1_1 += val_1;
    nr_1_2 += val_2;
    nr_1_3 += val_3;

    // (4) test for uniqueness of values
    for(auto& item2: *r) {
      idx_t v2 = item2.first;
      string* result2 = item2.second;

      if(v2 != v) {
        assert(result2->compare(*result) != 0);
      }
    }
  }

  assert(nr_1_0 == 5);
  assert(nr_1_1 >= 4 && nr_1_1 <= 6);
  assert(nr_1_2 >= 4 && nr_1_2 <= 6);
  assert(nr_1_3 >= 2 && nr_1_3 <= 8);

  // (5) test for the values of the second bit (based on
  // my assumptions on how METIS should work...)
  //assert( (*((*r)[1]))[1] == (*((*r)[3]))[1] );

  for(auto& item: *r) {
    delete item.second;
  }

  for(auto& item: *res) {
    delete item.second;
  }

  delete r;
  delete res;

  for(auto& item: *_r) {
    delete item.second;
  }

  for(auto& item: *_res) {
    delete item.second;
  }

  delete _r;
  delete _res;

  delete loaded_g_t;
  delete loaded_g_m;

  printf("OK\n");

  return 0;
}
