#include "globals.h"
#include "utils/graphIO.h"
#include "utils/debug.h"
#include "representations/tradListGraphR.h"
#include "representations/metisR.h"
#include "partitioners/recPart.h"
#include "representations/diffGraphR.h"
#include "coders/myVarintByteBasedCoder.h"
#include "offsetStructures/offsetsPtrs.h"

bool verbose = true;

int main() {
  TradListGraphR*  loaded_g_t = NULL;
  MetisR* loaded_g_m = NULL;

  /*assert(argc == 4);
  int balance = atoi(argv[1]);
  int full = atoi(argv[2]);
  int lvls = atoi(argv[3]);
  const char* file_name = "../input/g1.txt";*/

  int balance = 1;
  int full = 1;
  int lvls = 0;
  const char* file_name = "../input/g1.txt";

  GraphIO::loadGraph(file_name, &loaded_g_t, &loaded_g_m);

  RecPart part;
  SimpleRecGraphR* r;
  CutResults* res;
  part.recEdgePartition(METIS_PARTITIONING_MULTITHREADED, loaded_g_m, balance, full, lvls, &r, &res);

  DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>* dif = new DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>(NO_CHANGES, r, loaded_g_t);

  assert(dif->adjUseV1Neighbors(0,2) == true);
  assert(dif->adjUseV1Neighbors(0,3) == false);
  assert(dif->adjUseV1Neighbors(2,0) == true);
  assert(dif->adjUseV1Neighbors(2,1) == true);
  assert(dif->adjUseV1Neighbors(2,2) == false);
  assert(dif->adjUseV1Neighbors(2,3) == true);
  assert(dif->adjUseV1Neighbors(2,4) == true);

  assert(dif->adjUseV2Neighbors(0,2) == true);
  assert(dif->adjUseV2Neighbors(0,3) == false);
  assert(dif->adjUseV2Neighbors(2,0) == true);
  assert(dif->adjUseV2Neighbors(2,1) == true);
  assert(dif->adjUseV2Neighbors(2,2) == false);
  assert(dif->adjUseV2Neighbors(2,3) == true);
  assert(dif->adjUseV2Neighbors(2,4) == true);
 
  assert(dif->adjUseMinNeighbors(0,2) == true);
  assert(dif->adjUseMinNeighbors(0,3) == false);
  assert(dif->adjUseMinNeighbors(2,0) == true);
  assert(dif->adjUseMinNeighbors(2,1) == true);
  assert(dif->adjUseMinNeighbors(2,2) == false);
  assert(dif->adjUseMinNeighbors(2,3) == true);
  assert(dif->adjUseMinNeighbors(2,4) == true);
 
  v_id neighs_nr = 0;
  v_id* neighs = dif->getVertexNeighborsAndDegree(2, &neighs_nr);
  assert(neighs_nr == 4);
  assert(neighs[0] == 0);
  assert(neighs[1] == 1);
  assert(neighs[2] == 3);
  assert(neighs[3] == 4);
  assert(dif->getVertexDegree(2) == 4);
  delete [] neighs;

  neighs_nr = 0;
  neighs = dif->getVertexNeighborsAndDegree(6, &neighs_nr);
  assert(neighs_nr == 3);
  assert(neighs[0] == 5);
  assert(neighs[1] == 7);
  assert(neighs[2] == 8);
  assert(dif->getVertexDegree(6) == 3);
  delete [] neighs;
 
  neighs_nr = 0;
  neighs = dif->getVertexNeighborsAndDegree(7, &neighs_nr);
  assert(neighs_nr == 4);
  assert(neighs[0] == 4);
  assert(neighs[1] == 5);
  assert(neighs[2] == 6);
  assert(neighs[3] == 8);
  assert(dif->getVertexDegree(7) == 4);
  delete [] neighs;
 
  neighs_nr = 0;
  neighs = dif->getVertexNeighborsAndDegree(8, &neighs_nr);
  assert(neighs_nr == 3);
  assert(neighs[0] == 5);
  assert(neighs[1] == 6);
  assert(neighs[2] == 7);
  assert(dif->getVertexDegree(8) == 3);
  delete [] neighs;
 
  neighs_nr = 0;
  neighs = dif->getVertexNeighborsAndDegree(0, &neighs_nr);
  assert(neighs_nr == 1);
  assert(neighs[0] == 2);
  assert(dif->getVertexDegree(0) == 1);
  delete [] neighs;
 
  for(auto& item: *r) {
    string* result = item.second;
    delete result;
  }

  for(auto& item: *res) {
    delete item.second;
  }

  delete r;
  delete res;

  delete loaded_g_t;
  delete loaded_g_m;

  delete dif;

  printf("OK\n");

  return 0;
}
