#include "globals.h"
#include "utils/graphIO.h"
#include "utils/debug.h"
#include "representations/tradListGraphR.h"
#include "representations/metisR.h"
#include "partitioners/recPart.h"
#include "representations/diffGraphR.h"
#include "coders/myVarintByteBasedCoder.h"
#include "coders/myVarintByteBasedNoDiffCoder.h"
#include "offsetStructures/offsetsPtrs.h"
#include "offsetStructures/offsetsBV.h"
#include "offsetStructures/offsetsBV_IL.h"
#include "offsetStructures/offsetsBV_SD.h"
#include "offsetStructures/offsetsBV_RRR.h"

bool verbose = true;

int main() {
  TradListGraphR*  loaded_g_t = NULL;
  MetisR* loaded_g_m = NULL;

  /*assert(argc == 4);
  int balance = atoi(argv[1]);
  int full = atoi(argv[2]);
  int lvls = atoi(argv[3]);
  const char* file_name = "../input/g1.txt";*/

  int balance = 1;
  int full = 1;
  int lvls = 0;
  const char* file_name = "../input/g1.txt";

  GraphIO::loadGraph(file_name, &loaded_g_t, &loaded_g_m, 1);

  RecPart part;
  SimpleRecGraphR* r;
  CutResults* res;
  part.recEdgePartition(METIS_PARTITIONING, loaded_g_m, balance, full, lvls, &r, &res);

  DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>* dif = new DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>(NO_CHANGES, r, loaded_g_t);
  DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>* dif_i = new DiffGraphR<OffsetsPtrs, MyVarintByteBasedCoder>(INORDER, r, loaded_g_t);
  DiffGraphR<OffsetsPtrs, MyVarintByteBasedNoDiffCoder>* dif_deg = new DiffGraphR<OffsetsPtrs, MyVarintByteBasedNoDiffCoder>(DEGREE_HIGH_TO_LOW, r, loaded_g_t);

  DiffGraphR<OffsetsBV, MyVarintByteBasedCoder>* dif_bv = new DiffGraphR<OffsetsBV, MyVarintByteBasedCoder>(NO_CHANGES, r, loaded_g_t);
  DiffGraphR<OffsetsBV, MyVarintByteBasedCoder>* dif_bv_i = new DiffGraphR<OffsetsBV, MyVarintByteBasedCoder>(INORDER, r, loaded_g_t);
  DiffGraphR<OffsetsBV, MyVarintByteBasedNoDiffCoder>* dif_bv_deg = new DiffGraphR<OffsetsBV, MyVarintByteBasedNoDiffCoder>(DEGREE_HIGH_TO_LOW, r, loaded_g_t);

  DiffGraphR<OffsetsBV_SD, MyVarintByteBasedCoder>* dif_bv_sd = new DiffGraphR<OffsetsBV_SD, MyVarintByteBasedCoder>(NO_CHANGES, r, loaded_g_t);
  DiffGraphR<OffsetsBV_SD, MyVarintByteBasedCoder>* dif_bv_sd_i = new DiffGraphR<OffsetsBV_SD, MyVarintByteBasedCoder>(INORDER, r, loaded_g_t);
  DiffGraphR<OffsetsBV_SD, MyVarintByteBasedNoDiffCoder>* dif_bv_sd_deg = new DiffGraphR<OffsetsBV_SD, MyVarintByteBasedNoDiffCoder>(DEGREE_HIGH_TO_LOW, r, loaded_g_t);

  DiffGraphR<OffsetsBV_IL, MyVarintByteBasedCoder>* dif_bv_il = new DiffGraphR<OffsetsBV_IL, MyVarintByteBasedCoder>(NO_CHANGES, r, loaded_g_t);
  DiffGraphR<OffsetsBV_IL, MyVarintByteBasedCoder>* dif_bv_il_i = new DiffGraphR<OffsetsBV_IL, MyVarintByteBasedCoder>(INORDER, r, loaded_g_t);
  DiffGraphR<OffsetsBV_IL, MyVarintByteBasedNoDiffCoder>* dif_bv_il_deg = new DiffGraphR<OffsetsBV_IL, MyVarintByteBasedNoDiffCoder>(DEGREE_HIGH_TO_LOW, r, loaded_g_t);

  DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>* dif_bv_rrr = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>(NO_CHANGES, r, loaded_g_t);
  DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>* dif_bv_rrr_i = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedCoder>(INORDER, r, loaded_g_t);
  DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedNoDiffCoder>* dif_bv_rrr_deg = new DiffGraphR<OffsetsBV_RRR, MyVarintByteBasedNoDiffCoder>(DEGREE_HIGH_TO_LOW, r, loaded_g_t);




  assert(dif->adjUseV1Neighbors(0,2) == true);
  assert(dif->adjUseV1Neighbors(0,3) == false);
  assert(dif->adjUseV1Neighbors(2,0) == true);
  assert(dif->adjUseV1Neighbors(2,1) == true);
  assert(dif->adjUseV1Neighbors(2,2) == false);
  assert(dif->adjUseV1Neighbors(2,3) == true);
  assert(dif->adjUseV1Neighbors(2,4) == true);

  assert(dif->adjUseV2Neighbors(0,2) == true);
  assert(dif->adjUseV2Neighbors(0,3) == false);
  assert(dif->adjUseV2Neighbors(2,0) == true);
  assert(dif->adjUseV2Neighbors(2,1) == true);
  assert(dif->adjUseV2Neighbors(2,2) == false);
  assert(dif->adjUseV2Neighbors(2,3) == true);
  assert(dif->adjUseV2Neighbors(2,4) == true);
 
  assert(dif->adjUseMinNeighbors(0,2) == true);
  assert(dif->adjUseMinNeighbors(0,3) == false);
  assert(dif->adjUseMinNeighbors(2,0) == true);
  assert(dif->adjUseMinNeighbors(2,1) == true);
  assert(dif->adjUseMinNeighbors(2,2) == false);
  assert(dif->adjUseMinNeighbors(2,3) == true);
  assert(dif->adjUseMinNeighbors(2,4) == true);
 
  v_id neighs_nr = 0;
  v_id* neighs = dif->getVertexNeighborsAndDegree(2, &neighs_nr);
  assert(neighs_nr == 4);
  assert(neighs[0] == 0);
  assert(neighs[1] == 1);
  assert(neighs[2] == 3);
  assert(neighs[3] == 4);
  assert(dif->getVertexDegree(2) == 4);
  delete [] neighs;

  neighs_nr = 0;
  neighs = dif->getVertexNeighborsAndDegree(6, &neighs_nr);
  assert(neighs_nr == 3);
  assert(neighs[0] == 5);
  assert(neighs[1] == 7);
  assert(neighs[2] == 8);
  assert(dif->getVertexDegree(6) == 3);
  delete [] neighs;
 
  neighs_nr = 0;
  neighs = dif->getVertexNeighborsAndDegree(7, &neighs_nr);
  assert(neighs_nr == 4);
  assert(neighs[0] == 4);
  assert(neighs[1] == 5);
  assert(neighs[2] == 6);
  assert(neighs[3] == 8);
  assert(dif->getVertexDegree(7) == 4);
  delete [] neighs;
 
  neighs_nr = 0;
  neighs = dif->getVertexNeighborsAndDegree(8, &neighs_nr);
  assert(neighs_nr == 3);
  assert(neighs[0] == 5);
  assert(neighs[1] == 6);
  assert(neighs[2] == 7);
  assert(dif->getVertexDegree(8) == 3);
  delete [] neighs;
 
  neighs_nr = 0;
  neighs = dif->getVertexNeighborsAndDegree(0, &neighs_nr);
  assert(neighs_nr == 1);
  assert(neighs[0] == 2);
  assert(dif->getVertexDegree(0) == 1);
  delete [] neighs;




  // BV

 



  assert(dif_bv->adjUseV1Neighbors(0,2) == true);
  assert(dif_bv->adjUseV1Neighbors(0,3) == false);
  assert(dif_bv->adjUseV1Neighbors(2,0) == true);
  assert(dif_bv->adjUseV1Neighbors(2,1) == true);
  assert(dif_bv->adjUseV1Neighbors(2,2) == false);
  assert(dif_bv->adjUseV1Neighbors(2,3) == true);
  assert(dif_bv->adjUseV1Neighbors(2,4) == true);

  assert(dif_bv->adjUseV2Neighbors(0,2) == true);
  assert(dif_bv->adjUseV2Neighbors(0,3) == false);
  assert(dif_bv->adjUseV2Neighbors(2,0) == true);
  assert(dif_bv->adjUseV2Neighbors(2,1) == true);
  assert(dif_bv->adjUseV2Neighbors(2,2) == false);
  assert(dif_bv->adjUseV2Neighbors(2,3) == true);
  assert(dif_bv->adjUseV2Neighbors(2,4) == true);
 
  assert(dif_bv->adjUseMinNeighbors(0,2) == true);
  assert(dif_bv->adjUseMinNeighbors(0,3) == false);
  assert(dif_bv->adjUseMinNeighbors(2,0) == true);
  assert(dif_bv->adjUseMinNeighbors(2,1) == true);
  assert(dif_bv->adjUseMinNeighbors(2,2) == false);
  assert(dif_bv->adjUseMinNeighbors(2,3) == true);
  assert(dif_bv->adjUseMinNeighbors(2,4) == true);
 
  neighs_nr = 0;
  neighs = dif_bv->getVertexNeighborsAndDegree(2, &neighs_nr);
  assert(neighs_nr == 4);
  assert(neighs[0] == 0);
  assert(neighs[1] == 1);
  assert(neighs[2] == 3);
  assert(neighs[3] == 4);
  assert(dif_bv->getVertexDegree(2) == 4);
  delete [] neighs;

  neighs_nr = 0;
  neighs = dif_bv->getVertexNeighborsAndDegree(6, &neighs_nr);
  assert(neighs_nr == 3);
  assert(neighs[0] == 5);
  assert(neighs[1] == 7);
  assert(neighs[2] == 8);
  assert(dif_bv->getVertexDegree(6) == 3);
  delete [] neighs;
 
  neighs_nr = 0;
  neighs = dif_bv->getVertexNeighborsAndDegree(7, &neighs_nr);
  assert(neighs_nr == 4);
  assert(neighs[0] == 4);
  assert(neighs[1] == 5);
  assert(neighs[2] == 6);
  assert(neighs[3] == 8);
  assert(dif_bv->getVertexDegree(7) == 4);
  delete [] neighs;
 
  neighs_nr = 0;
  neighs = dif_bv->getVertexNeighborsAndDegree(8, &neighs_nr);
  assert(neighs_nr == 3);
  assert(neighs[0] == 5);
  assert(neighs[1] == 6);
  assert(neighs[2] == 7);
  assert(dif_bv->getVertexDegree(8) == 3);
  delete [] neighs;
 
  neighs_nr = 0;
  neighs = dif_bv->getVertexNeighborsAndDegree(0, &neighs_nr);
  assert(neighs_nr == 1);
  assert(neighs[0] == 2);
  assert(dif_bv->getVertexDegree(0) == 1);
  delete [] neighs;
 







  //BV SD





  assert(dif_bv_sd->adjUseV1Neighbors(0,2) == true);
  assert(dif_bv_sd->adjUseV1Neighbors(0,3) == false);
  assert(dif_bv_sd->adjUseV1Neighbors(2,0) == true);
  assert(dif_bv_sd->adjUseV1Neighbors(2,1) == true);
  assert(dif_bv_sd->adjUseV1Neighbors(2,2) == false);
  assert(dif_bv_sd->adjUseV1Neighbors(2,3) == true);
  assert(dif_bv_sd->adjUseV1Neighbors(2,4) == true);

  assert(dif_bv_sd->adjUseV2Neighbors(0,2) == true);
  assert(dif_bv_sd->adjUseV2Neighbors(0,3) == false);
  assert(dif_bv_sd->adjUseV2Neighbors(2,0) == true);
  assert(dif_bv_sd->adjUseV2Neighbors(2,1) == true);
  assert(dif_bv_sd->adjUseV2Neighbors(2,2) == false);
  assert(dif_bv_sd->adjUseV2Neighbors(2,3) == true);
  assert(dif_bv_sd->adjUseV2Neighbors(2,4) == true);
 
  assert(dif_bv_sd->adjUseMinNeighbors(0,2) == true);
  assert(dif_bv_sd->adjUseMinNeighbors(0,3) == false);
  assert(dif_bv_sd->adjUseMinNeighbors(2,0) == true);
  assert(dif_bv_sd->adjUseMinNeighbors(2,1) == true);
  assert(dif_bv_sd->adjUseMinNeighbors(2,2) == false);
  assert(dif_bv_sd->adjUseMinNeighbors(2,3) == true);
  assert(dif_bv_sd->adjUseMinNeighbors(2,4) == true);
 
  neighs_nr = 0;
  neighs = dif_bv_sd->getVertexNeighborsAndDegree(2, &neighs_nr);
  assert(neighs_nr == 4);
  assert(neighs[0] == 0);
  assert(neighs[1] == 1);
  assert(neighs[2] == 3);
  assert(neighs[3] == 4);
  assert(dif_bv_sd->getVertexDegree(2) == 4);
  delete [] neighs;

  neighs_nr = 0;
  neighs = dif_bv_sd->getVertexNeighborsAndDegree(6, &neighs_nr);
  assert(neighs_nr == 3);
  assert(neighs[0] == 5);
  assert(neighs[1] == 7);
  assert(neighs[2] == 8);
  assert(dif_bv_sd->getVertexDegree(6) == 3);
  delete [] neighs;
 
  neighs_nr = 0;
  neighs = dif_bv_sd->getVertexNeighborsAndDegree(7, &neighs_nr);
  assert(neighs_nr == 4);
  assert(neighs[0] == 4);
  assert(neighs[1] == 5);
  assert(neighs[2] == 6);
  assert(neighs[3] == 8);
  assert(dif_bv_sd->getVertexDegree(7) == 4);
  delete [] neighs;
 
  neighs_nr = 0;
  neighs = dif_bv_sd->getVertexNeighborsAndDegree(8, &neighs_nr);
  assert(neighs_nr == 3);
  assert(neighs[0] == 5);
  assert(neighs[1] == 6);
  assert(neighs[2] == 7);
  assert(dif_bv_sd->getVertexDegree(8) == 3);
  delete [] neighs;
 
  neighs_nr = 0;
  neighs = dif_bv_sd->getVertexNeighborsAndDegree(0, &neighs_nr);
  assert(neighs_nr == 1);
  assert(neighs[0] == 2);
  assert(dif_bv_sd->getVertexDegree(0) == 1);
  delete [] neighs;
 








  // BV IL




  assert(dif_bv_il->adjUseV1Neighbors(0,2) == true);
  assert(dif_bv_il->adjUseV1Neighbors(0,3) == false);
  assert(dif_bv_il->adjUseV1Neighbors(2,0) == true);
  assert(dif_bv_il->adjUseV1Neighbors(2,1) == true);
  assert(dif_bv_il->adjUseV1Neighbors(2,2) == false);
  assert(dif_bv_il->adjUseV1Neighbors(2,3) == true);
  assert(dif_bv_il->adjUseV1Neighbors(2,4) == true);

  assert(dif_bv_il->adjUseV2Neighbors(0,2) == true);
  assert(dif_bv_il->adjUseV2Neighbors(0,3) == false);
  assert(dif_bv_il->adjUseV2Neighbors(2,0) == true);
  assert(dif_bv_il->adjUseV2Neighbors(2,1) == true);
  assert(dif_bv_il->adjUseV2Neighbors(2,2) == false);
  assert(dif_bv_il->adjUseV2Neighbors(2,3) == true);
  assert(dif_bv_il->adjUseV2Neighbors(2,4) == true);
 
  assert(dif_bv_il->adjUseMinNeighbors(0,2) == true);
  assert(dif_bv_il->adjUseMinNeighbors(0,3) == false);
  assert(dif_bv_il->adjUseMinNeighbors(2,0) == true);
  assert(dif_bv_il->adjUseMinNeighbors(2,1) == true);
  assert(dif_bv_il->adjUseMinNeighbors(2,2) == false);
  assert(dif_bv_il->adjUseMinNeighbors(2,3) == true);
  assert(dif_bv_il->adjUseMinNeighbors(2,4) == true);
 
  neighs_nr = 0;
  neighs = dif_bv_il->getVertexNeighborsAndDegree(2, &neighs_nr);
  assert(neighs_nr == 4);
  assert(neighs[0] == 0);
  assert(neighs[1] == 1);
  assert(neighs[2] == 3);
  assert(neighs[3] == 4);
  assert(dif_bv_il->getVertexDegree(2) == 4);
  delete [] neighs;

  neighs_nr = 0;
  neighs = dif_bv_il->getVertexNeighborsAndDegree(6, &neighs_nr);
  assert(neighs_nr == 3);
  assert(neighs[0] == 5);
  assert(neighs[1] == 7);
  assert(neighs[2] == 8);
  assert(dif_bv_il->getVertexDegree(6) == 3);
  delete [] neighs;
 
  neighs_nr = 0;
  neighs = dif_bv_il->getVertexNeighborsAndDegree(7, &neighs_nr);
  assert(neighs_nr == 4);
  assert(neighs[0] == 4);
  assert(neighs[1] == 5);
  assert(neighs[2] == 6);
  assert(neighs[3] == 8);
  assert(dif_bv_il->getVertexDegree(7) == 4);
  delete [] neighs;
 
  neighs_nr = 0;
  neighs = dif_bv_il->getVertexNeighborsAndDegree(8, &neighs_nr);
  assert(neighs_nr == 3);
  assert(neighs[0] == 5);
  assert(neighs[1] == 6);
  assert(neighs[2] == 7);
  assert(dif_bv_il->getVertexDegree(8) == 3);
  delete [] neighs;
 
  neighs_nr = 0;
  neighs = dif_bv_il->getVertexNeighborsAndDegree(0, &neighs_nr);
  assert(neighs_nr == 1);
  assert(neighs[0] == 2);
  assert(dif_bv_il->getVertexDegree(0) == 1);
  delete [] neighs;
 






  // BV RRR
 





  assert(dif_bv_rrr->adjUseV1Neighbors(0,2) == true);
  assert(dif_bv_rrr->adjUseV1Neighbors(0,3) == false);
  assert(dif_bv_rrr->adjUseV1Neighbors(2,0) == true);
  assert(dif_bv_rrr->adjUseV1Neighbors(2,1) == true);
  assert(dif_bv_rrr->adjUseV1Neighbors(2,2) == false);
  assert(dif_bv_rrr->adjUseV1Neighbors(2,3) == true);
  assert(dif_bv_rrr->adjUseV1Neighbors(2,4) == true);

  assert(dif_bv_rrr->adjUseV2Neighbors(0,2) == true);
  assert(dif_bv_rrr->adjUseV2Neighbors(0,3) == false);
  assert(dif_bv_rrr->adjUseV2Neighbors(2,0) == true);
  assert(dif_bv_rrr->adjUseV2Neighbors(2,1) == true);
  assert(dif_bv_rrr->adjUseV2Neighbors(2,2) == false);
  assert(dif_bv_rrr->adjUseV2Neighbors(2,3) == true);
  assert(dif_bv_rrr->adjUseV2Neighbors(2,4) == true);
 
  assert(dif_bv_rrr->adjUseMinNeighbors(0,2) == true);
  assert(dif_bv_rrr->adjUseMinNeighbors(0,3) == false);
  assert(dif_bv_rrr->adjUseMinNeighbors(2,0) == true);
  assert(dif_bv_rrr->adjUseMinNeighbors(2,1) == true);
  assert(dif_bv_rrr->adjUseMinNeighbors(2,2) == false);
  assert(dif_bv_rrr->adjUseMinNeighbors(2,3) == true);
  assert(dif_bv_rrr->adjUseMinNeighbors(2,4) == true);
 
  neighs_nr = 0;
  neighs = dif_bv_rrr->getVertexNeighborsAndDegree(2, &neighs_nr);
  assert(neighs_nr == 4);
  assert(neighs[0] == 0);
  assert(neighs[1] == 1);
  assert(neighs[2] == 3);
  assert(neighs[3] == 4);
  assert(dif_bv_rrr->getVertexDegree(2) == 4);
  delete [] neighs;

  neighs_nr = 0;
  neighs = dif_bv_rrr->getVertexNeighborsAndDegree(6, &neighs_nr);
  assert(neighs_nr == 3);
  assert(neighs[0] == 5);
  assert(neighs[1] == 7);
  assert(neighs[2] == 8);
  assert(dif_bv_rrr->getVertexDegree(6) == 3);
  delete [] neighs;
 
  neighs_nr = 0;
  neighs = dif_bv_rrr->getVertexNeighborsAndDegree(7, &neighs_nr);
  assert(neighs_nr == 4);
  assert(neighs[0] == 4);
  assert(neighs[1] == 5);
  assert(neighs[2] == 6);
  assert(neighs[3] == 8);
  assert(dif_bv_rrr->getVertexDegree(7) == 4);
  delete [] neighs;
 
  neighs_nr = 0;
  neighs = dif_bv_rrr->getVertexNeighborsAndDegree(8, &neighs_nr);
  assert(neighs_nr == 3);
  assert(neighs[0] == 5);
  assert(neighs[1] == 6);
  assert(neighs[2] == 7);
  assert(dif_bv_rrr->getVertexDegree(8) == 3);
  delete [] neighs;
 
  neighs_nr = 0;
  neighs = dif_bv_rrr->getVertexNeighborsAndDegree(0, &neighs_nr);
  assert(neighs_nr == 1);
  assert(neighs[0] == 2);
  assert(dif_bv_rrr->getVertexDegree(0) == 1);
  delete [] neighs;
 









 
  for(auto& item: *r) {
    string* result = item.second;
    delete result;
  }

  for(auto& item: *res) {
    delete item.second;
  }

  delete r;
  delete res;

  delete loaded_g_t;
  delete loaded_g_m;

  delete dif;
  delete dif_i;
  delete dif_deg;

  delete dif_bv;
  delete dif_bv_i;
  delete dif_bv_deg;

  delete dif_bv_sd;
  delete dif_bv_sd_i;
  delete dif_bv_sd_deg;

  delete dif_bv_il;
  delete dif_bv_il_i;
  delete dif_bv_il_deg;

  delete dif_bv_rrr;
  delete dif_bv_rrr_i;
  delete dif_bv_rrr_deg;

  printf("OK\n");

  return 0;
}
