#include "convert.h"

string decToBin(unsigned int number, size_t len) {
  string result = ""; assert(result.length() == 0);
  if(len == 0) {
    return result;
  }

  do {
    if ( (number & 1) == 0 ) {
      result += "0";
    }
    else {
      result += "1";
    }

    number >>= 1;
  } while ( number );

  assert(result.length() <= len);

  for(unsigned int i = result.length(); i < len; ++i) {
    result += "0";
  }

  reverse(result.begin(), result.end());
  return result;
}

// TODO: tests
// TODO: inline
int charbitToInt(char sign) {
  assert(sign == '0' || sign == '1');
  return sign - '0';
}

int intbitToChar(int sign) {
  assert(sign == 0 || sign == 1);
  return sign + '0';
}

// TODO: tests
v_id binToDec(string number) {
  return binToDec(&number);
}

string commonPrefix(string s1, string s2) {
  return commonPrefix(&s1, &s2);
}

// TODO: tests
v_id binToDec(string* number) {
  int len = number->length();
  assert(len > 0);
  v_id number_int = 0;

  for(int i = (len - 1); i >= 0; --i) {
    char sign = (*number)[i];
    number_int += charbitToInt(sign) * ((uint64_t)1 << (len - i - 1));
  }

  return number_int;
}

string commonPrefix(string* s1, string* s2) {
  assert(s1->length() == s2->length());
  string prefix("");
  for(int i = 0; i < (int)s1->length(); ++i) {
    if((*s1)[i] != (*s2)[i]) {
      break;
    }
    prefix += ((*s1)[i]);
  }

  return prefix;
}
