#include "graphIO.h"

namespace GraphIO {

  //void convertGraph(map<v_id, set<v_id>* >* in, MetisR** out) {
  void convertGraph(const SimpleTupleGraphR* const tg, MetisR** out) {
    SimpleEdge* edges = tg->edges;
    std::map<v_id, std::set<v_id>* >* adj = new std::map<v_id, std::set<v_id>* >();

    v_id n = tg->n_;
    v_id m = tg->m_;

    //TODO: add also packed edges

    //int64_t v0 = -1;
    //int64_t v1 = -1;

    for(int64_t e = 0; e < tg->m_; ++e) {
      assert(edges[e].v0 >= 0);
      assert(edges[e].v1 >= 0);
      assert(edges[e].v0 < n);
      assert(edges[e].v1 < n);
      //v0 = edges[e].v0;
      //v1 = edges[e].v1;

      if(edges[e].v0 == edges[e].v1) continue;

      if(adj->find(edges[e].v0) == adj->end()) {
        (*adj)[edges[e].v0] = new std::set<v_id>();
        (*adj)[edges[e].v0]->insert(edges[e].v1);
        ++m;
      }

      if(adj->find(edges[e].v1) == adj->end()) {
        (*adj)[edges[e].v1] = new std::set<v_id>();
        (*adj)[edges[e].v1]->insert(edges[e].v0);
        ++m;
      }

      if((*adj)[edges[e].v0]->find(edges[e].v1) == (*adj)[edges[e].v0]->end()) {
        ++m;
      }

      if((*adj)[edges[e].v1]->find(edges[e].v0) == (*adj)[edges[e].v1]->end()) {
        ++m;
      }
    }

    assert(tg->n_ == (int64_t)adj->size());
    assert(m % 2 == 0);
    m /= 2;

    idx_t* xadj = new idx_t[n+1];
    idx_t* adjncy = new idx_t[2*m];
    xadj[0] = 0;

    v_id v_processed = 0;
    v_id e_processed = 0;

    for(auto& item : *adj) {
      set<v_id>* ns = item.second;

      vector<v_id> new_ns;
      xadj[1+v_processed] = (idx_t)ns->size() + xadj[v_processed];
      ++v_processed;

      for(v_id neigh: *ns) {
        assert(neigh >= 0); 
        assert(neigh < n);

        adjncy[e_processed++] = (idx_t)neigh; 
      }
    }

    assert(n == v_processed);
    assert(2*m == e_processed);

    *out = new MetisR(xadj, adjncy, n, m);

    delete adj;
  }

  void loadGraph(const char* file_name, TradArrayNoDegGraphR** g_t_out, int first_vertex_id_in_file) {
    TradArrayNoDegGraphR* g_t;

    string line; // for reading a line from the file
    ifstream in_f(file_name);

    if(!in_f) {
      exitMsg("Cannot open input graph file.");
    }

    assert(first_vertex_id_in_file >= 0);

    v_id v_processed = 0;
    v_id e_processed = 0;
    v_id isolated_v = 0;

    getline(in_f, line);
    istringstream is(line);
    v_id n, m;
    string w;
    is >> n >> m >> w;

    assert(w == "Y" || w == "N" || w == "");
    //bool weighted = ( (w == "Y") ? true : false);
    //is >> n >> m;

    g_t = new TradArrayNoDegGraphR(n,m);

    v_id* adj = g_t->adj_;
    v_id* offsets = g_t->offsets_;

    while(getline(in_f, line)) {
      istringstream is(line);

      vector<v_id> ns = vector<v_id>( istream_iterator<v_id>(is), istream_iterator<v_id>() );

      //TODO: make sure python script does that!
      sort(ns.begin(), ns.end());

      offsets[v_processed] = e_processed;

      for(v_id neigh: ns) {
        //make sure that our assumption that the graph in file starts from 1 holds
        assert(neigh >= first_vertex_id_in_file); 
        assert(neigh < n + first_vertex_id_in_file);

        //we subtract one because we want to use C-like style in METIS that starts from 0
        adj[e_processed++] = (v_id)neigh - first_vertex_id_in_file; 
      }

      if(ns.size() == 0) {
        ++isolated_v;
      }

      ++v_processed;
    }

    offsets[v_processed] = e_processed;

    assert(n == v_processed);
    assert(2*m == e_processed);

    *g_t_out = g_t;
  }

  void loadGraph(const char* file_name, TradArrayNoDegEWGraphR** g_t_out, int first_vertex_id_in_file) {
    TradArrayNoDegEWGraphR* g_t;

    string line; // for reading a line from the file
    ifstream in_f(file_name);

    if(!in_f) {
      exitMsg("Cannot open input graph file.");
    }

    assert(first_vertex_id_in_file >= 0);

    v_id v_processed = 0;
    v_id e_processed = 0;
    v_id isolated_v = 0;

    getline(in_f, line);
    istringstream is(line);
    v_id n, m;
    string w;
    is >> n >> m >> w;

    assert(w == "Y" || w == "N" || w == "");
    bool weighted = ( (w == "Y") ? true : false);

    g_t = new TradArrayNoDegEWGraphR(n,m);

    v_id* adj = g_t->adj_;
    v_id* offsets = g_t->offsets_;

    while(getline(in_f, line)) {
      istringstream is(line);

      vector<v_id> line_vals;
      if(weighted) {
        line_vals = vector<v_id>( istream_iterator<v_id>(is), istream_iterator<v_id>() );
      }
      else {
        //cout << "A" << endl;
        //cerr << "A" << endl;
        //TODO: make it faster by using a list.
        vector<v_id> _line_vals = vector<v_id>( istream_iterator<v_id>(is), istream_iterator<v_id>() );
        std::list<v_id> _list;
        std::copy( _line_vals.begin(), _line_vals.end(), std::back_inserter( _list ) );

    

        //vector<v_id>::iterator it = line_vals.begin();
        list<v_id>::iterator it = _list.begin();
        //cout << "List begin: " << *it << endl;
        //cerr << "List begin: " << *it << endl;


        if(it != _list.end()) {
          //cout << "List is not empty!" << endl;
          //++it;
          //cout << "After the initial ++it " << *it << endl;
          //_list.insert(it, 1);
          //++it;
          //cout << "After the initial insert " << *it << endl;
          int x = 0;
          while(it != _list.end()) {
            //do 
          assert(_line_vals[x] == *it);
            //cout << "Itr " << x << " start: " << *it << endl;
            //cerr << "Itr " << x << " start: " << *it << endl;
            
            ++it;
            
            _list.insert(it, 1);
            //cout << "After " << x << " insert " << *it << endl;
            //++it;
            //cout << "After " << x << " ++it " << *it << endl;
            ++x;
          } //while(it != _list.end());

          //_list.insert(it, 1);

          /*v_id inserted = line_vals.size();
            for(v_id a = 0; a < inserted; ++a) {
            ++it;
            line_vals.insert(it, 1);
            }*/
        }

        //vector<v_id> line_vals{ std::begin(_list), std::end(_list) };
        std::copy( _list.begin(), _list.end(), std::back_inserter( line_vals ) );

        //cerr << "B" << endl;
        //assert(it == line_vals.end());
        //cout << "]]] ";
        for(v_id a = 0; a < (v_id)line_vals.size(); ++a) {
         // cout << line_vals[a] << " ";
          if(a % 2 == 1) {
            assert(line_vals[a] == 1);
          }
        }
       //cout << endl;
        //cerr << "1" << endl;
      }

        //cerr << "2" << endl;
      assert(line_vals.size() % 2 == 0);

      vector< pair<v_id, v_id> > ns;

      for(v_id i = 0; i < (v_id)(line_vals.size() / 2); ++i) {
        ns.push_back( pair<v_id, v_id>(line_vals[2*i], line_vals[2*i + 1]) );
      }

        //cerr << "3" << endl;
      sort(ns.begin(), ns.end());

      offsets[v_processed] = e_processed;

        //cerr << "4" << endl;
      for(pair<v_id,v_id> neigh_pair: ns) {
        v_id neigh = neigh_pair.first;
        v_id neigh_weight = neigh_pair.second;

//        cout << "neigh: " << neigh << ", w: " << neigh_weight << endl;
        //make sure that our assumption that the graph in file starts from 1 holds
        assert(neigh >= first_vertex_id_in_file); 
        assert(neigh < n + first_vertex_id_in_file);

        //we subtract one because we want to use C-like style in METIS that starts from 0
        adj[e_processed++] = (v_id)neigh - first_vertex_id_in_file; 
        adj[e_processed++] = neigh_weight;
      }

        //cerr << "5" << endl;
      if(ns.size() == 0) {
        ++isolated_v;
      }

      ++v_processed;
    }

        //cerr << "6" << endl;
    offsets[v_processed] = e_processed;
        //cerr << "7" << endl;

    assert(n == v_processed);
  //  cout << "-------" <<  4*m << " " << e_processed << endl;
    assert(4*m == e_processed);

    *g_t_out = g_t;
        //cerr << "8" << endl;
  }

  void loadGraph(const char* file_name, TradArrayGraphR** g_t_out, int first_vertex_id_in_file) {
    TradArrayGraphR* g_t;

    string line; // for reading a line from the file
    ifstream in_f(file_name);
        cerr << "C" << endl;

    if(!in_f) {
      exitMsg("Cannot open input graph file.");
    }

    assert(first_vertex_id_in_file >= 0);

    v_id v_processed = 0;
    v_id e_processed = 0;
    v_id offset = 0;
    v_id isolated_v = 0;

    getline(in_f, line);
    istringstream is(line);
    v_id n, m;
    //is >> n >> m;
    string w;
    is >> n >> m >> w;

    assert(w == "Y" || w == "N" || w == "");
    //bool weighted = ( (w == "Y") ? true : false);

    g_t = new TradArrayGraphR(n,m);

    v_id* adj = g_t->adj_;
    v_id* offsets = g_t->offsets_;

    while(getline(in_f, line)) {
      istringstream is(line);

      vector<v_id> ns = vector<v_id>( istream_iterator<v_id>(is), istream_iterator<v_id>() );

      //TODO: make sure python script does that!
      sort(ns.begin(), ns.end());

      offsets[v_processed] = offset;
      adj[offset] = ns.size();
      ++offset;

      for(v_id neigh: ns) {
        //make sure that our assumption that the graph in file starts from 1 holds
        assert(neigh >= first_vertex_id_in_file); 
        assert(neigh < n + first_vertex_id_in_file);

        //we subtract one because we want to use C-like style in METIS that starts from 0
        adj[offset++] = (v_id)neigh - first_vertex_id_in_file; 
        ++e_processed;
      }

      if(ns.size() == 0) {
        ++isolated_v;
      }

      ++v_processed;
    }

    offsets[v_processed] = offset;

    assert(n == v_processed);
    assert(2*m == e_processed);
    assert( (2*m + n) == offset);

    *g_t_out = g_t;
  }

  void loadGraph(const char* file_name, TradListGraphR** g_t_out, MetisR** g_m_out, int first_vertex_id_in_file) {
    TradListGraphR* g_t;

    string line; // for reading a line from the file
    ifstream in_f(file_name);

    if(!in_f) {
      exitMsg("Cannot open input graph file.");
    }

    assert(first_vertex_id_in_file >= 0);

    v_id v_processed = 0;
    v_id e_processed = 0;
    v_id isolated_v = 0;

    getline(in_f, line);
    istringstream is(line);
    v_id n, m;
    //is >> n >> m;
    string w;
    is >> n >> m >> w;

    assert(w == "Y" || w == "N" || w == "");
    //bool weighted = ( (w == "Y") ? true : false);

    g_t = new TradListGraphR(n,m);

    idx_t* xadj = new idx_t[n+1];
    idx_t* adjncy = new idx_t[2*m];
    xadj[0] = 0;

    while(getline(in_f, line)) {
      istringstream is(line);

      vector<v_id> ns = vector<v_id>( istream_iterator<v_id>(is), istream_iterator<v_id>() );

      //TODO: make sure python script does that!
      sort(ns.begin(), ns.end());

      vector<v_id> new_ns;
      xadj[1+v_processed] = (idx_t)ns.size() + xadj[v_processed];

      for(v_id neigh: ns) {
        //make sure that our assumption that the graph in file starts from 1 holds
        assert(neigh >= first_vertex_id_in_file); 
        assert(neigh < n + first_vertex_id_in_file);

        //we subtract one because we want to use C-like style in METIS that starts from 0
        adjncy[e_processed++] = (idx_t)neigh - first_vertex_id_in_file; 
        new_ns.push_back((v_id)neigh - first_vertex_id_in_file);
      }

      (*(g_t->adj_))[v_processed++] = new_ns;
      if(new_ns.size() == 0) {
        ++isolated_v;
      }
    }

    assert(n == v_processed);
    assert(2*m == e_processed);

    MetisR* g_m = new MetisR(xadj, adjncy, n, m);

    *g_t_out = g_t;
    *g_m_out = g_m;
  }


  void writeRecursivePartitioningToFile(SimpleRecGraphR* rep, std::string f_name) {
    ofstream file;
    file.open(f_name);

    for(auto& item : *rep) {
      v_id v = item.first;
      string* s = item.second;
      file << v << " " << *s << endl;
    }

    file.close();
  }

  SimpleRecGraphR* readRecursivePartitioningFromFile(std::string f_name) {
    ifstream file;
    file.open(f_name);

    if(!file) {
      exitMsg("Cannot open input recursive bisectioning graph file.");
    }

    SimpleRecGraphR* r = new SimpleRecGraphR();

    v_id v;
    string s;

    while(file >> v >> s) {
      (*r)[v] = new string(s);
    }
    file.close();

    return r;
  }

} /* end of namespace IO */
