#if !defined(__GRAPH_IO_H__)
#define      __GRAPH_IO_H__

#include "metis.h"

#include "globals.h"
#include "representations/tradListGraphR.h"
#include "representations/tradArrayGraphR.h"
#include "representations/tradArrayNoDegGraphR.h"
#include "representations/tradArrayNoDegEWGraphR.h"
#include "representations/metisR.h"
#include "representations/misc.h"
#include "representations/tupleGraphR.h"
#include "utils/debug.h"

namespace GraphIO {

void loadGraph(const char* file_name, TradListGraphR** g_t_out, MetisR** g_m_out, int first_vertex_id_in_file = 1);
void loadGraph(const char* file_name, TradArrayGraphR** g_t_out, int first_vertex_id_in_file = 1);
void loadGraph(const char* file_name, TradArrayNoDegGraphR** g_t_out, int first_vertex_id_in_file = 1);

void loadGraph(const char* file_name, TradArrayNoDegEWGraphR** g_t_out, int first_vertex_id_in_file = 1);

void convertGraph(const SimpleTupleGraphR* const tg, MetisR** out);
void writeRecursivePartitioningToFile(SimpleRecGraphR* rep, std::string f_name);
SimpleRecGraphR* readRecursivePartitioningFromFile(std::string f_name);

}

#endif
