#include "myVarint.h"

// TODO: convert intomacros (?) or inline
// TODO; try to write to the array of chars using one 64 bit


//TODO: unsued_bits adds overhead, remove it for actual perf. benchmarks
int toVarint(uint64_t x, unsigned char* out, uint64_t* unused_bits) {
  if(x == 0) {
    *out = 0;
    *unused_bits = 6;
    return 1;
  }

  if(x < TWO_POW_7) {
    *out = x & BIT_8_CLEAR;
    int bits = 7 - ((int)log2(x)+1);
    assert(bits >= 0);
    *unused_bits = bits;
    return 1;
  }
  else if(x >= TWO_POW_7 && x < TWO_POW_14) {
    *out = (x & BIT_8_CLEAR) | BIT_8_SET;
    *(out+1) = (x >> 7) & BIT_8_CLEAR;
    int bits = 7 - ((int)log2(*(out+1))+1);
    assert(bits >= 0);
    *unused_bits = bits;
    return 2;
  }
  else if(x >= TWO_POW_14 && x < TWO_POW_21) {
    *out = (x & BIT_8_CLEAR) | BIT_8_SET;
    *(out+1) = ((x >> 7) & BIT_8_CLEAR) | BIT_8_SET;
    *(out+2) = ((x >> 14) & BIT_8_CLEAR);
    int bits = 7 - ((int)log2(*(out+2))+1);
    assert(bits >= 0);
    *unused_bits = bits;
    return 3;
  }
  else if(x >= TWO_POW_21 && x < TWO_POW_28) {
    *out = (x & BIT_8_CLEAR) | BIT_8_SET;
    *(out+1) = ((x >> 7) & BIT_8_CLEAR) | BIT_8_SET;
    *(out+2) = ((x >> 14) & BIT_8_CLEAR) | BIT_8_SET;
    *(out+3) = ((x >> 21) & BIT_8_CLEAR);
    int bits = 7 - ((int)log2(*(out+3))+1);
    assert(bits >= 0);
    *unused_bits = bits;
    return 4;
  }
  else if(x >= TWO_POW_28 && x < TWO_POW_35) {
    *out = (x & BIT_8_CLEAR) | BIT_8_SET;
    *(out+1) = ((x >> 7) & BIT_8_CLEAR) | BIT_8_SET;
    *(out+2) = ((x >> 14) & BIT_8_CLEAR) | BIT_8_SET;
    *(out+3) = ((x >> 21) & BIT_8_CLEAR) | BIT_8_SET;
    *(out+4) = ((x >> 28) & BIT_8_CLEAR);
    int bits = 7 - ((int)log2(*(out+4))+1);
    assert(bits >= 0);
    *unused_bits = bits;
    return 5;
  }
  else if(x >= TWO_POW_35 && x < TWO_POW_42) {
    *out = (x & BIT_8_CLEAR) | BIT_8_SET;
    *(out+1) = ((x >> 7) & BIT_8_CLEAR) | BIT_8_SET;
    *(out+2) = ((x >> 14) & BIT_8_CLEAR) | BIT_8_SET;
    *(out+3) = ((x >> 21) & BIT_8_CLEAR) | BIT_8_SET;
    *(out+4) = ((x >> 28) & BIT_8_CLEAR) | BIT_8_SET;
    *(out+5) = ((x >> 35) & BIT_8_CLEAR);
    int bits = 7 - ((int)log2(*(out+5))+1);
    assert(bits >= 0);
    *unused_bits = bits;
    return 6;
  }
  else if(x >= TWO_POW_42 && x < TWO_POW_49) {
    *out = (x & BIT_8_CLEAR) | BIT_8_SET;
    *(out+1) = ((x >> 7) & BIT_8_CLEAR) | BIT_8_SET;
    *(out+2) = ((x >> 14) & BIT_8_CLEAR) | BIT_8_SET;
    *(out+3) = ((x >> 21) & BIT_8_CLEAR) | BIT_8_SET;
    *(out+4) = ((x >> 28) & BIT_8_CLEAR) | BIT_8_SET;
    *(out+5) = ((x >> 35) & BIT_8_CLEAR) | BIT_8_SET;
    *(out+6) = ((x >> 42) & BIT_8_CLEAR);
    int bits = 7 - ((int)log2(*(out+6))+1);
    assert(bits >= 0);
    *unused_bits = bits;
    return 7;
  }
  else if(x >= TWO_POW_49 && x < TWO_POW_56) {
    *out = (x & BIT_8_CLEAR) | BIT_8_SET;
    *(out+1) = ((x >> 7) & BIT_8_CLEAR) | BIT_8_SET;
    *(out+2) = ((x >> 14) & BIT_8_CLEAR) | BIT_8_SET;
    *(out+3) = ((x >> 21) & BIT_8_CLEAR) | BIT_8_SET;
    *(out+4) = ((x >> 28) & BIT_8_CLEAR) | BIT_8_SET;
    *(out+5) = ((x >> 35) & BIT_8_CLEAR) | BIT_8_SET;
    *(out+6) = ((x >> 42) & BIT_8_CLEAR) | BIT_8_SET;
    *(out+7) = ((x >> 49) & BIT_8_CLEAR);
    int bits = 7 - ((int)log2(*(out+7))+1);
    assert(bits >= 0);
    *unused_bits = bits;
    return 8;
  }

  assert(false);
  return -1;
}

int fromVarint(unsigned char* in, uint64_t* out) {
  unsigned char more = (*in) & BIT_8_SET;
  unsigned char val = (*in) & BIT_8_CLEAR;
  int next = 1;
  *out = val;

  while(more == BIT_8_SET) {
    ++in;
    more = (*in) & BIT_8_SET;
    val = (*in) & BIT_8_CLEAR;
    *out += (val << 7*next);
    ++next;
  }
  
  return next;
}

int fromVarint(unsigned char* in, v_id* out) {
  unsigned char more = (*in) & BIT_8_SET;
  unsigned char val = (*in) & BIT_8_CLEAR;
  int next = 1;
  *out = val;

  while(more == BIT_8_SET) {
    ++in;
    more = (*in) & BIT_8_SET;
    val = (*in) & BIT_8_CLEAR;
    *out += (val << 7*next);
    ++next;
  }
  
  return next;
}

/* 
int fromVarint(unsigned char* in, uint64_t bytes, uint64_t* out) {
//  unsigned char* in = _in;
  unsigned char more = (*in) & BIT_8_SET;
  unsigned char val = (*in) & BIT_8_CLEAR;
  int next = 1;
  *out = val;

  while(more == BIT_8_SET) {
    ++in;
    more = (*in) & BIT_8_SET;
    val = (*in) & BIT_8_CLEAR;
    *out += (val << 7*next);
    ++next;
  }
  
  return next;
}

int fromVarint(unsigned char* in, uint64_t bytes, v_id* out) {
//  unsigned char* in = _in;
  unsigned char more = (*in) & BIT_8_SET;
  unsigned char val = (*in) & BIT_8_CLEAR;
  int next = 1;
  *out = val;

  while(more == BIT_8_SET) {
    ++in;
    more = (*in) & BIT_8_SET;
    val = (*in) & BIT_8_CLEAR;
    *out += (val << 7*next);
    ++next;
  }
  
  return next;
}

*/




