#include "sharedMemoryLocks.h"

void TASLock::lock() {
  while(std::atomic_flag_test_and_set_explicit(&locked_, std::memory_order_acquire));
}

void TASLock::unlock() {
  std::atomic_flag_clear_explicit(&locked_, std::memory_order_release);
}

void TTASLock::lock() {
  bool exp = false;
  do {
    while(locked_.load(std::memory_order_relaxed) == 1);
  } while(!locked_.compare_exchange_weak(exp, true, std::memory_order_acquire));
}

void TTASLock::unlock() {
  locked_.store(false, std::memory_order_release);
}
