#if !defined(__SH_MEM_LOCKS_H__)
#define      __SH_MEM_LOCKS_H__

#include <atomic>
#include "globals.h"

using namespace std;

class SimpleLock {
 public:
  virtual void lock() = 0;
  virtual void unlock() = 0;
};

class TASLock : public SimpleLock {
 public:
  TASLock() : locked_(ATOMIC_FLAG_INIT) {}

  void lock();
  void unlock();
  
 private:
  volatile std::atomic_flag locked_;
};

class TTASLock : public SimpleLock {
 public:
  TTASLock() : locked_(false) {}

  void lock();
  void unlock();
  
 private:
  volatile std::atomic_bool locked_;
};

#endif
