#include "stats.h"

vector<int> PapiStats::events_daint_0;
vector<int> PapiStats::events_daint_1;
vector<int> PapiStats::events_daint_2;
vector<int> PapiStats::events_daint_3;
vector<int> PapiStats::events_daint_4;
map<int, vector<int>* > PapiStats::papi_daint_events;

void PapiStats::init_global_papi() {
  assert(PAPI_library_init( PAPI_VER_CURRENT ) == PAPI_VER_CURRENT );
  assert(PAPI_thread_init( ( unsigned long ( * )( void ) ) ( omp_get_thread_num ) ) == PAPI_OK );
  assert(PAPI_num_counters() >= 2);
  assert(PAPI_get_hardware_info() != NULL);

  assert(sizeof(long long) * CHAR_BIT == 64);
  assert(sizeof(uint64_t) * CHAR_BIT == 64);

  int e_0[] = {PAPI_LD_INS, PAPI_SR_INS, PAPI_BR_INS, PAPI_BR_UCN, PAPI_BR_CN};
  for(int i = 0; i < 5; ++i) {
    events_daint_0.push_back(e_0[i]);
  }

  int e_1[] = {PAPI_L1_TCM, PAPI_L2_TCM, PAPI_L3_TCM};
  for(int i = 0; i < 3; ++i) {
    events_daint_1.push_back(e_1[i]);
  }

  int e_2[] = {PAPI_TLB_DM, PAPI_TLB_IM};
  for(int i = 0; i < 2; ++i) {
    events_daint_2.push_back(e_2[i]);
  }

  int e_3[] = {PAPI_CA_SNP, PAPI_CA_INV, PAPI_PRF_DM, PAPI_MEM_WCY, PAPI_STL_ICY, PAPI_RES_STL, PAPI_TOT_INS, PAPI_BR_MSP, PAPI_BR_PRC};
  for(int i = 0; i < 8; ++i) {
    events_daint_3.push_back(e_3[i]);
  }

  int e_4[] = {PAPI_L1_DCM, PAPI_L1_ICM, PAPI_L2_DCM, PAPI_L2_ICM};
  for(int i = 0; i < 3; ++i) {
    events_daint_4.push_back(e_4[i]);
  }


  papi_daint_events[0] = &events_daint_0;
  papi_daint_events[1] = &events_daint_1;
  papi_daint_events[2] = &events_daint_2;
  papi_daint_events[3] = &events_daint_3;
  papi_daint_events[4] = &events_daint_4;
}

PapiStats::PapiStats(int set_id) {
  this->set_id = set_id;
  events = new int[ papi_daint_events[set_id]->size() ]();
  std::copy(papi_daint_events[set_id]->begin(), papi_daint_events[set_id]->end(), events);

  values = new long long[ papi_daint_events[set_id]->size() ]();
  zero_all_stats();
}

PapiStats::~PapiStats() {
  delete [] events;
  delete [] values;
}

void PapiStats::increase_global_stats(PapiStats* s, PapiStats* my_s) {
  assert(s->set_id == my_s->set_id);
  for(int i = 0; i < (int) ((papi_daint_events[s->set_id])->size() ); ++i) {
    __sync_fetch_and_add(&((s->values)[i]), (my_s->values)[i]);
  }
  __sync_synchronize();
}

void MemoryStats::increase_global_stats(MemoryStats* s, MemoryStats* my_s) {
  __sync_fetch_and_add(&(s->mem_reads_), my_s->mem_reads_);
  __sync_fetch_and_add(&(s->mem_writes_), my_s->mem_writes_);
  __sync_fetch_and_add(&(s->cas_succ_), my_s->cas_succ_);
  __sync_fetch_and_add(&(s->cas_unsucc_), my_s->cas_unsucc_);
  __sync_fetch_and_add(&(s->fad_), my_s->fad_);
//  __sync_fetch_and_add(&(s->fad_total_), my_s->fad_total_);
  __sync_fetch_and_add(&(s->omp_critical_), my_s->omp_critical_);
  __sync_synchronize();
}

void MemoryStats::increase_atomic_global_stats(MemoryStats* s, MemoryStats* my_s) {
  __sync_fetch_and_add(&(s->cas_succ_), my_s->cas_succ_);
  __sync_fetch_and_add(&(s->cas_unsucc_), my_s->cas_unsucc_);
  __sync_fetch_and_add(&(s->fad_), my_s->fad_);
  __sync_synchronize();
}

void MemoryStats::increase_lock_global_stats(MemoryStats* s, MemoryStats* my_s) {
  __sync_fetch_and_add(&(s->omp_critical_), my_s->omp_critical_);
  __sync_synchronize();
}

void MemoryStats::increase_remote_global_stats(MemoryStats* s, MemoryStats* my_s) {
  __sync_fetch_and_add(&(s->local_fompi_gac_sum_), my_s->local_fompi_gac_sum_);
  __sync_fetch_and_add(&(s->remote_fompi_gac_sum_), my_s->remote_fompi_gac_sum_);
  __sync_synchronize();
}

