import re, string, sys, copy

def is_number(s):
  try:
    float(s)
    return True
  except ValueError:
    return False

if len(sys.argv) != 4:
  sys.exit("usage: "+sys.argv[0]+" <input file> <from> <to>");

from_unit = sys.argv[2]
to_unit = sys.argv[3]

assert("B" <> "b")

assert(from_unit == "b" or from_unit == "B" or from_unit == "KB" or from_unit == "MB" or from_unit == "GB")
assert(to_unit == "b" or to_unit == "B" or to_unit == "KB" or to_unit == "MB" or to_unit == "GB")

f = open(sys.argv[1])
f_out = open(sys.argv[1] + "_" + to_unit, "w")
firstline = 1

for line in f:
  if firstline == 1: 
    firstline = 0 # skip first line
    f_out.write(line)
    continue

  s = string.split(line, " ");
  new_line = ""
  for i in range(0,len(s)):
    if(not is_number(s[i])):
      new_line += s[i] + " "
      continue
   
    assert(is_number(s[i]))

    amount = float(s[i])

    if(from_unit == "B"):
      amount *= 8
    elif(from_unit == "KB"):
      amount *= 8*1024
    elif(from_unit == "MB"):
      amount *= 8*1024*1024
    elif(from_unit == "GB"):
      amount *= 8*1024*1024*1024

    if(to_unit == "B"):
      amount /= 8
    elif(to_unit == "KB"):
      amount /= 8*1024
    elif(to_unit == "MB"):
      amount /= 8*1024*1024
    elif(to_unit == "GB"):
      amount /= 8*1024*1024*1024

    new_line += str(amount) + " "
    if(i == (len(s)-1)):
      new_line += "\n"

  f_out.write(new_line)

f_out.close()
f.close()
