import re, string, sys, copy

def is_number(s):
  try:
    float(s)
    return True
  except ValueError:
    return False

if len(sys.argv) < 4:
  sys.exit("usage: "+sys.argv[0]+" <input file> <col> <cols...>");

col = sys.argv[2]
n_cols = []

suffix="_col-" + col + "_normalized-to-cols-"

for i in range(3,len(sys.argv)):
  n_col = int(sys.argv[i])
  n_cols.append(n_col)
  suffix += sys.argv[i] + "-"

print col
print n_cols

f = open(sys.argv[1])
f_out = open(sys.argv[1] + suffix, "w")
firstline = 1

for line in f:
  if firstline == 1: 
    firstline = 0 # skip first line
    f_out.write(line)
    continue

  s = string.split(line, " ");
  divide=s[int(col)]
  new_line = ""
  for i in range(0,len(s)):
    if(not is_number(s[i])):
      new_line += s[i] + " "
      continue
 
    if(not (i in n_cols)):
      new_line += s[i] + " "
      continue
  
    assert(is_number(s[i]))

    amount = float(s[i])/float(divide)

    new_line += str(amount) + " "
    if(i == (len(s)-1)):
      new_line += "\n"

  f_out.write(new_line)

f_out.close()
f.close()
