#include "various.h"

double getMaxDiff(double* v1, double* v2, v_id n) {
  double max_diff = 0.0;
  for(v_id v = 0; v < n; ++v) {
    double diff = fabs(v1[v] - v2[v]);
    if(diff > max_diff) {
      max_diff = diff;
    }
  }
  return max_diff;
}

int64_t getMaxDiff(int64_t* v1, int64_t* v2, v_id n) {
  int64_t max_diff = 0.0;
  for(v_id v = 0; v < n; ++v) {
    int64_t diff = fabs(v1[v] - v2[v]);
    if(diff > max_diff) {
      max_diff = diff;
    }
  }
  return max_diff;
}


double getMaxElem(double* v1, v_id n) {
  double max = std::numeric_limits<double>::min();
  for(v_id v = 0; v < n; ++v) {
    if(v1[v] > max) {
      max = v1[v];
    }
  }
  return max;
}

double getMinElem(double* v1, v_id n) {
  double min = std::numeric_limits<double>::max();
  for(v_id v = 0; v < n; ++v) {
    if(v1[v] < min) {
      min = v1[v];
    }
  }
  return min;
}

double getAvg(double* v1, v_id n) {
  double sum = 0;
  for(v_id v = 0; v < n; ++v) {
    sum += v1[v];
  }

  return sum / n;
}

