#include <string>
#include <vector>

#include "InputBitStream.h"

using namespace std;

class BV_Graph {
private:
	const string PROPERTIES_EXTENSION = ".properties";
	const string GRAPH_EXTENSION = ".graph";
	const string OFFSETS_EXTENSION = ".offsets";
	const int DEFAULT_ZETA_K = 3;
	
	string basename;
	int num_nodes;
	long num_edges;
	int window_size;
	int min_interval_length;

	InputBitStream *adj;
	InputBitStream *deg;
	long *offsets;

public:
	BV_Graph(const char* file_name);
	BV_Graph(string b, int n, long m, int ws, int mil, long *off, InputBitStream *a, InputBitStream *d);
	~BV_Graph();
	BV_Graph* copy();
	void resetPointers();
	void readProperties();
	void loadOffsets();

	int getNumNodes();
	long getNumEdges();
	string getBasename();

	void setPosition(InputBitStream *ibs, long pos);
	long readOffset(InputBitStream *off_ibs);
	int readDegree(InputBitStream *adj_ibs);
	int readReference(InputBitStream *adj_ibs);
	int readBlockCount(InputBitStream *adj_ibs);
	int readBlock(InputBitStream *adj_ibs);
	int readIntervalCount(InputBitStream *adj_ibs);
	int readLeft(InputBitStream *adj_ibs);
	long readLongLeft(InputBitStream *adj_ibs);
	int readLen(InputBitStream *adj_ibs);
	int readResidual(InputBitStream *adj_ibs);
	long readLongResidual(InputBitStream *adj_ibs);

	int getVertexDegree(int v);
	void getVertexNeighbors(int v, vector<int> *neighs);
};