#include <cstdio>
#include <iostream>
#include "InputBitStream.h"

unsigned char OkreniByte(unsigned char bbb)
{
unsigned char rez = 0;

	for(int j=0; j<8; j++){

		if(bbb & (0x01<<j)){
		
			rez |= (0x0080>>j);
		
		}
	}
	return rez;
}



InputBitStream::InputBitStream(long64 size, long64 *bsd)
{
	Position = 0;
	Size = size;
	BitStreamData = bsd;
}

InputBitStream* InputBitStream::copy() {
	InputBitStream *ibs = new InputBitStream(Size, BitStreamData);
	return ibs;
}

InputBitStream::InputBitStream(const char *FileName)
{
	unsigned char Byte;
	Position = 0;

	FILE *fh;
	long64 lSize,i;
	unsigned char *buffer;
    size_t result;

	fh = fopen( FileName , "rb" );
	if (fh==NULL)
	{
		fputs("File Error !!!!!",stderr);
		exit(1);
	}

  	// obtain file size:
	fseek (fh , 0 , SEEK_END);
	lSize = ftell (fh);
	rewind(fh);

	// Reyervisi memoriju za ceo fajl:

	buffer = (unsigned char*) malloc(sizeof(char)* lSize);
	if (buffer == NULL)
	{
		fputs ("Memory error",stderr);
		exit(2);
	}

	// procitaj fajl u buffer:
	result = fread (buffer,1,lSize,fh);
	if (result != lSize)
	{
		fputs ("Reading error",stderr);
		exit(3);
	}

	/* Sad radi sa buffer sta oces. */
	BitStreamData = (long64 *)calloc((lSize+7)/8,8);

  
	for(i=0; i<lSize; i++){
	
		Byte = OkreniByte(buffer[i]);
		BitStreamData[i/8] = BitStreamData[i/8] | ((long64)Byte << (8*(i%8)) );
	
	}
	// Sve ucitano i spakovano

	Size = lSize;

	fclose(fh);
	free(buffer);



}

InputBitStream::~InputBitStream(void)
{
}

void InputBitStream::SetPosition(long64 Pos)
{
	Position = Pos;
}


int InputBitStream::ReadUnary()
{
	int res = 0;
//	cout << "start pos: " << Position << endl;
	long64 rb_bloka = Position / 64;
	long64 poz_u_bloku = Position % 64;

	long64 shifter = (s << poz_u_bloku);

	while ((BitStreamData[rb_bloka] & shifter) != shifter)
	{
		if (poz_u_bloku < 63) /*&& (BitStreamData[rb_bloka] & shifter) != shifter)*/
		{
			res++;
			poz_u_bloku++;
			shifter = shifter << 1;
		}
		else if (poz_u_bloku == 63)
		{
			res++;
			poz_u_bloku = 0;
			shifter = 1;
			rb_bloka++;

			while (BitStreamData[rb_bloka] == 0)
			{
				res = res + 64;
				rb_bloka++;
			}
		}
	}



	SetPosition(rb_bloka * 64 + poz_u_bloku+1);

//	cout << "read unary: " << res << " pos: " << Position << endl;
	return res;
};


int  InputBitStream::ReadDelta()
{
int res;

	int km1 = ReadGamma();
		
	res = (1<<km1) | ReadInt(km1);
	
//	Position += km1;
	
	return res-1;

}

long  InputBitStream::ReadLongDelta()
{
long res;

	int km1 = ReadGamma();
		
	res = ((long)1<<km1) | ReadLong(km1);
	
//	Position += km1;
	return res-1;

}



int  InputBitStream::ReadGamma()
{
int res;
//	cout << "start pos: " << Position << endl;
	int km1 = ReadUnary();
	
	res = (1<<km1) | ReadInt(km1);

//	Position += km1;
//	cout << "read gamma: " << res-1 << " pos: " << Position << endl;
	return res-1;

}

long  InputBitStream::ReadLongGamma()
{
long res;
//	cout << "start pos: " << Position << endl;
	
	int km1 = ReadUnary();
	
	res = ((long)1<<km1) | ReadLong(km1);

//	Position += km1;
//	cout << "read long gamma: " << res-1 << " pos: " << Position << endl;
	return res - 1;

}

int  InputBitStream::ReadZeta(int k)
{
int h;
int left;
int m;

	h = ReadUnary();
	left = 1 << (h * k);
	m = ReadInt( h * k + k - 1 );
	if( m < left )
		return m + left - 1;
	
	return ( m << 1 ) + ReadBit() - 1; 
}


long  InputBitStream::ReadLongZeta(int k)
{
int h;
long left;
long m;

	h = ReadUnary();
	left = 1 << (h * k);
	m = ReadLong( h * k + k - 1 );
	if( m < left )
		return m + left - 1;
	
	return ( m << 1 ) + ReadBit() - 1; 
}



int InputBitStream::ReadInt(int k)
{
int res=0;
for(int i=0; i<k; i++){

	res |= (ReadBit()<<(k-i-1));
}

return res;
}





/*
int InputBitStream::ReadInt(int k)
{
int res=0;
for(int i=0; i<k; i++){

	res |= ReadBit()<<i;
}

return res;
}
*/


/*
int InputBitStream::ReadInt(int k)
{
long64 res=0;
long64 pom = 0;
long64 rb_bloka = Position / 64;
long64 poz_u_bloku = Position % 64;
long64 shifter;
long64 stara_poz = 64;

	if (k > 64 - poz_u_bloku)
	{
		shifter = (s << (64 - poz_u_bloku)) - s;
		shifter = shifter << poz_u_bloku;

		pom = (BitStreamData[rb_bloka] & shifter) >> (poz_u_bloku);
		rb_bloka++;
		stara_poz = poz_u_bloku;
		poz_u_bloku = 0x00;
		k = k - (64 - stara_poz);
	}

	shifter = ((s << k) - s);
	shifter = shifter << poz_u_bloku;

	res = ((BitStreamData[rb_bloka] & shifter) << (64 - stara_poz));

	res = res | pom;
	if (poz_u_bloku != 0)
		res = res >> poz_u_bloku;
	Position += k;
	return res;
}

*/

/*
long  InputBitStream::ReadLong(int k)
{
long64 res=0;
long64 pom = 0;
long64 rb_bloka = Position / 64;
long64 poz_u_bloku = Position % 64;
long64 shifter;
long64 stara_poz = 64;

	if (k > 64 - poz_u_bloku)
	{
		shifter = (s << (64 - poz_u_bloku)) - s;
		shifter = shifter << poz_u_bloku;

		pom = (BitStreamData[rb_bloka] & shifter) >> (poz_u_bloku);
		rb_bloka++;
		stara_poz = poz_u_bloku;
		poz_u_bloku = 0x00;
		k = k - (64 - stara_poz);
	}

	shifter = ((s << k) - s);
	shifter = shifter << poz_u_bloku;

	res = ((BitStreamData[rb_bloka] & shifter) << (64 - stara_poz));

	res = res | pom;
	if (poz_u_bloku != 0)
		res = res >> poz_u_bloku;
	Position += k;
	return res;
}
*/

/*
long  InputBitStream::ReadLong(int k)
{
long res=0;
for(int i=0; i<k; i++){

	res |= (long)ReadBit()<<i;
}

return res;
}
*/

long InputBitStream::ReadLong(int k)
{
long res=0;

for(int i=0; i<k; i++){

	res |= ((long)ReadBit()<<(k-i-1));
}

return res;
}




int InputBitStream::ReadBit(void)
{

	if((BitStreamData[Position/64] & (s << (Position%64))) == 0)
	{
		Position++;
	    return 0;

	}else{
	
		Position++;
		return 1;
	}
}