#pragma once
#include  <cstdint>
#include <cstdlib>

using namespace std;

typedef uint64_t long64;   // Ovde treba definisati tip koji je veliki 64 bita, zavisno od jezika
const long64 s = 0x01;

class InputBitStream
{

public:
	InputBitStream(long64 size, long64 *bsd);
	InputBitStream(const char *FileName);
	~InputBitStream(void);
	InputBitStream* copy();
	
	int ReadUnary();
	int ReadDelta();
	long ReadLongDelta();
	int ReadGamma();
	long ReadLongGamma();
	int ReadZeta(int k);
	long ReadLongZeta(int k);
	int ReadInt(int k);
	long ReadLong(int k);
	void SetPosition(long64 Pos);

private:
	long64 *BitStreamData;
	long64 Position;
	long64 Size;

	
	int ReadBit();

};
